package com.castlabs.sdk.broadpeak_demo;

import android.app.Activity;
import android.os.Bundle;

import com.castlabs.android.PlayerSDK;
import com.castlabs.sdk.broadpeak.BroadpeakComponent;
import com.castlabs.sdk.broadpeak.BroadpeakPlugin;
import com.google.android.material.snackbar.Snackbar;
import android.util.Log;

import com.castlabs.android.player.PlayerView;
import com.castlabs.sdk.playerui.PlayerControllerProgressBar;
import com.castlabs.sdk.playerui.PlayerControllerView;

public class SimplePlaybackDemo extends Activity {
	private static final String TAG = "SimplePlaybackDemo";
	// This is the player view that we use to start playback
	private PlayerView playerView;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_simple_playback_demo);

		// Get the view components from the layout
		playerView = (PlayerView) findViewById(R.id.player_view);

		// In case it is desired to disable the Broadpeak for a particular view, it can be done
		// as follows. For this to take effect it must be done before PlayerController creation
		final BroadpeakPlugin plugin = PlayerSDK.getPlugin(BroadpeakPlugin.class);
		//plugin.setEnabled(false);

		// The Broadpeak URL redirect logic can be disabled prior to starting playback.
		// This is useful if the Broadpeak plugin was created, but now we're playing a non-BP
		// stream. Doing this saves some time upon playback start by skipping the BP redirect.
		BroadpeakComponent component = playerView.getPlayerController().getComponent(BroadpeakComponent.class);
		//component.setUrlRedirect(false);

		// This demo assumes that you send an intent to this Activity that contains the
		// playback information. We need to pass the intents bundle on to the PlayerController
		// to start playback. The open() method might throw an Exception in case the bundle
		// contains not all mandatory parameters or the parameters are malformed.
		if (getIntent() != null) {
			try {
				playerView.getPlayerController().open(getIntent().getExtras());
			} catch (Exception e) {
				Log.e(TAG, "Error while opening player: " + e.getMessage(), e);
				Snackbar.make(playerView, "Error while opening player: " + e.getMessage(),
						Snackbar.LENGTH_INDEFINITE).show();
			}
		} else {
			Snackbar.make(playerView, "No intent specified", Snackbar.LENGTH_INDEFINITE).show();
		}
	}

	// Delegate the onStart event to the player views lifecycle delegate.
	// The delegate will make sure that the screen safer will be disabled and
	// the display will not go to sleep
	@Override
	protected void onStart() {
		super.onStart();
		playerView.getLifecycleDelegate().start(this);
	}

	// Delegate the onResume event to the player views lifecycle delegate.
	// The delegate ensures that the player recovers from a saved state. This needs to
	// be implemented to ensure the the user can for example go to the home screen and
	// come back to this activity.
	@Override
	protected void onResume() {
		super.onResume();

		final PlayerControllerView controls = (PlayerControllerView) findViewById(R.id.player_controls);
		controls.bind(playerView);

		PlayerControllerProgressBar progressBar = (PlayerControllerProgressBar) findViewById(R.id.progress_bar);
		progressBar.bind(playerView.getPlayerController());

		playerView.getLifecycleDelegate().resume();
	}

	// Delegate the onStop event to the player views lifecycle delegate.
	// We release the player when the activity is stopped. This will release all the player
	// resources and save the current playback state. Saving the state is required so the
	// onResume callback can recover properly.
	@Override
	protected void onStop() {
		super.onStop();
		playerView.getLifecycleDelegate().releasePlayer(false);
	}
}
