package com.castlabs.sdk.mediasession_demo;

import android.os.Bundle;
import android.os.Parcelable;

import androidx.annotation.NonNull;

import java.util.ArrayList;

final class BundleBuilder {
	@NonNull
	private final Bundle bundle;

	BundleBuilder() {
		this.bundle = new Bundle();
	}

	BundleBuilder put(String key, Bundle value) {
		bundle.putBundle(key, value);
		return this;
	}

	BundleBuilder put(String key, String value) {
		bundle.putString(key, value);
		return this;
	}

	BundleBuilder put(String key, int value) {
		bundle.putInt(key, value);
		return this;
	}

	BundleBuilder put(String key, boolean value) {
		bundle.putBoolean(key, value);
		return this;
	}

	BundleBuilder put(String key, Parcelable value) {
		bundle.putParcelable(key, value);
		return this;
	}

	BundleBuilder put(String key, ArrayList<? extends Parcelable> value) {
		bundle.putParcelableArrayList(key, value);
		return this;
	}

	BundleBuilder put(String key, Parcelable[] value) {
		bundle.putParcelableArray(key, value);
		return this;
	}

	BundleBuilder put(String key, long value) {
		bundle.putLong(key, value);
		return this;
	}

	Bundle get() {
		return bundle;
	}
}
