package com.castlabs.sdk.youbora_demo;

import androidx.multidex.MultiDexApplication;

import com.castlabs.android.PlayerSDK;
import com.castlabs.demoutils.ActivityInsetManager;
import com.castlabs.sdk.ima.ImaPlugin;
import com.castlabs.sdk.youbora.YouboraPlugin;
import com.google.ads.interactivemedia.v3.api.ImaSdkFactory;
import com.google.ads.interactivemedia.v3.api.ImaSdkSettings;
import com.npaw.NpawPlugin;
import com.npaw.core.util.extensions.Log;
import com.npaw.diagnostics.DiagnosticOptions;

public class DemoApp extends MultiDexApplication {
	private static final String TAG = "DemoApp";

	private static final String YOUBORA_CUSTOMER_KEY = "castlabsdev";

	public NpawPlugin youboraPlugin;

	@Override
	public void onCreate() {
		super.onCreate();
		registerActivityLifecycleCallbacks(new ActivityInsetManager());

		// IMA
		// Register the IMA ads plugin
		ImaPlugin imaPlugin = new ImaPlugin();
		imaPlugin.setEnabled(true);
		// Set the IMA SDK settings
		ImaSdkSettings imaSdkSettings = ImaSdkFactory.getInstance().createImaSdkSettings();
		imaSdkSettings.setLanguage("en");
		imaPlugin.setImaSdkSettings(imaSdkSettings);
		PlayerSDK.register(imaPlugin);

		// Enable Youbora Analytics. If you're using Youbora Sessions, you'll need to add
		// the page tracking calls yourself. The Castlabs SDK will only take care of video tracking.
		// By passing the Youbora "Plugin" instance to the SDK, Youbora will link the video sessions
		// with the application session.
		this.youboraPlugin = new NpawPlugin.Builder(this, YOUBORA_CUSTOMER_KEY)
			// Debugging diagnostic options - shall be disabled in production
			.setDiagnosticOptions(new DiagnosticOptions(
					false,
					true,
					true,
					5 * 60 * 1_000L))
			// Enable Youbora Verbose logging - not intended for prod
			.setLogLevel(Log.Level.VERBOSE)
			.build();

		YouboraPlugin youboraPlugin = new YouboraPlugin(this.youboraPlugin);
		// In case Youbora Sessions are not to be enabled, there's no need to provide a
		// Youbora Plugin instance to the SDK. Instead, only the customer key is required
		//YouboraPlugin youboraPlugin = new YouboraPlugin(YOUBORA_CUSTOMER_KEY);

		// Optional: Report SDK warnings as Youbora non-fatal errors (default: false)
		//youboraPlugin.reportWarnings(true);
		PlayerSDK.register(youboraPlugin);

		PlayerSDK.init(getApplicationContext());
	}
}
