package com.castlabs.sdk.adobe_demo;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;

import com.adobe.mobile.MediaSettings;
import com.castlabs.android.SdkConsts;
import com.castlabs.android.drm.Drm;
import com.castlabs.android.drm.DrmTodayConfiguration;
import com.castlabs.sdk.adobe.AdobePlugin;

import androidx.appcompat.app.AppCompatActivity;

public class MainActivity extends AppCompatActivity {

	private static Demo[] DEMOS = new Demo[]{
		new Demo("Simple Playback (Clear)", "Play a clear VOD stream",
			SimplePlaybackDemo.class,
			new BundleBuilder()
				.put(SdkConsts.INTENT_URL, "http://demo.cf.castlabs.com/media/TOS/abr/Manifest_clean_sizes.mpd")
				.put(SdkConsts.INTENT_ANALYTICS_DATA, AdobePlugin.createMetadata(
					getMediaSettings("TOS Sample Android", 60.0,
						"player-android", "player-id",
						"25,50,75", true, 1200))
				)
				.get()),

		new Demo("Simple Playback (Widevine)", "Plays stream protected with Widevine.",
			SimplePlaybackDemo.class,
			new BundleBuilder()
				.put(SdkConsts.INTENT_URL, "http://livesim.dashif.org/livesim/start_1800/testpic_2s/Manifest.mpd")
				.put(SdkConsts.INTENT_ANALYTICS_DATA, AdobePlugin.createMetadata(
					getMediaSettings("TOS Sample Android Widevine", 60.0,
						"player-android", "player-id",
						"25,50,75", true, 1200))
				)
				.put(SdkConsts.INTENT_DRM_CONFIGURATION, new DrmTodayConfiguration.Builder(
					DrmTodayConfiguration.DRMTODAY_STAGING,
					"purchase",
					"sessionId",
					"six",
					"dasheverywhere_demo",
					Drm.Widevine
				).get())
				.get()),
	};

	private static final String TAG = "MainActivity";

	private ListView demosList;
	private ArrayAdapter<Demo> demoAdapter;

	private static MediaSettings getMediaSettings(String name, double length, String playerName,
												  String playerId, String milestones,
												  boolean segmentByMilestones, int trackSeconds) {
		final MediaSettings mediaSettings = MediaSettings.settingsWith(name, length, playerName, playerId);
		mediaSettings.milestones = milestones;
		mediaSettings.segmentByMilestones = segmentByMilestones;
		mediaSettings.trackSeconds = trackSeconds;
		return mediaSettings;
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		demosList = (ListView) findViewById(R.id.demos_list);
		demoAdapter = new ArrayAdapter<Demo>(this, R.layout.demo_list_item, DEMOS) {
			@Override
			public View getView(final int position, View convertView, ViewGroup parent) {
				View view = convertView == null ? getLayoutInflater().inflate(R.layout.demo_list_item, parent, false) : convertView;
				Demo item = getItem(position);
				((TextView) view.findViewById(R.id.title)).setText(item.name);
				((TextView) view.findViewById(R.id.description)).setText(item.description);
				return view;
			}
		};

		demosList.setAdapter(demoAdapter);
		demosList.setOnItemClickListener(new AdapterView.OnItemClickListener() {
			@Override
			public void onItemClick(AdapterView<?> parent, View view, final int position, long id) {
				final Demo item = demoAdapter.getItem(position);
				item.start(MainActivity.this);
			}
		});
	}

	static class Demo {
		public final String name;
		public final String description;
		private final Bundle bundle;
		private Class<? extends Activity> activityClass;

		Demo(String name, String description, Class<? extends Activity> activityClass, Bundle bundle) {
			this.name = name;
			this.description = description;
			this.activityClass = activityClass;
			this.bundle = bundle;
		}

		void start(Context context) {
			context.startActivity(new Intent(context, activityClass).putExtras(bundle));
		}
	}

	static class BundleBuilder {
		private final Bundle bundle;

		BundleBuilder() {
			this.bundle = new Bundle();
		}

		BundleBuilder put(String key, String value) {
			bundle.putString(key, value);
			return this;
		}

		BundleBuilder put(String key, int value) {
			bundle.putInt(key, value);
			return this;
		}

		BundleBuilder put(String key, boolean value) {
			bundle.putBoolean(key, value);
			return this;
		}

		BundleBuilder put(String key, Parcelable value) {
			bundle.putParcelable(key, value);
			return this;
		}

		Bundle get() {
			return bundle;
		}
	}
}
