package com.castlabs.sdk.analytics_demo.utils

import android.content.Context
import android.util.DisplayMetrics
import android.util.TypedValue

object Display {

	fun dpToPix(dp: Int, context: Context): Float {
		val dm = getDisplayMetrics(context)
		return TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP,dp.toFloat(),dm)
	}

	fun dpToPix(dp: Float, context: Context): Float {
		val dm = getDisplayMetrics(context)
		return TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP,dp,dm)
	}

	private fun getDisplayMetrics(context: Context): DisplayMetrics {
		return context.resources.displayMetrics
	}
}
