package com.castlabs.sdk.broadpeak_demo;

import android.app.Activity;
import android.os.Bundle;

import com.castlabs.android.player.PlayerConfig;
import com.castlabs.android.player.PlayerView;
import com.castlabs.sdk.playerui.PlayerControllerProgressBar;
import com.castlabs.sdk.playerui.PlayerControllerView;

import androidx.annotation.Nullable;

/**
 * Player activity which plays two streams at once.
 *
 * Use {@link #BUNDLE_1} and {@link #BUNDLE_2} keys to define the two {@literal Bundles} when
 * starting this {@literal Activity}.
 */
public class TwinPlayerDemo extends Activity {

	public static final String BUNDLE_1 = "BUNDLE_1";
	public static final String BUNDLE_2 = "BUNDLE_2";

	private static final String SAVED_PLAYBACK_STATE_BUNDLE_KEY1 = "SAVED_PLAYBACK_STATE_BUNDLE_KEY1";
	private static final String SAVED_PLAYBACK_STATE_BUNDLE_KEY2 = "SAVED_PLAYBACK_STATE_BUNDLE_KEY2";
	private PlayerView playerView1;
	private PlayerView playerView2;
	private PlayerControllerView playerControllerView1;
	private PlayerControllerView playerControllerView2;

	@Override
	protected void onCreate(@Nullable Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.twin_player_demo);

		playerView1 = findViewById(R.id.player_view1);
		playerView2 = findViewById(R.id.player_view2);

		playerControllerView1 = findViewById(R.id.player_controls1);
		playerControllerView2 = findViewById(R.id.player_controls2);

		final Bundle extras = getIntent().getExtras();
		playerView1.getPlayerController().open((PlayerConfig) extras.getParcelable(BUNDLE_1));
		playerView2.getPlayerController().open((PlayerConfig) extras.getParcelable(BUNDLE_2));
	}

	@Override
	protected void onResume() {
		super.onResume();

		playerControllerView1.bind(playerView1);
		PlayerControllerProgressBar progressBar1 = findViewById(R.id.progress_bar1);
		progressBar1.bind(playerView1.getPlayerController());
		playerView1.getLifecycleDelegate().resume();

		playerControllerView2.bind(playerView2);
		PlayerControllerProgressBar progressBar2 = findViewById(R.id.progress_bar2);
		progressBar2.bind(playerView2.getPlayerController());
		playerView2.getLifecycleDelegate().resume();
	}

	@Override
	protected void onStart() {
		super.onStart();
		playerView1.getLifecycleDelegate().start(this);
		playerView2.getLifecycleDelegate().start(this);
	}

	@Override
	protected void onStop() {
		super.onStop();

		playerControllerView1.unbind();
		playerView1.getLifecycleDelegate().releasePlayer(false);

		playerControllerView2.unbind();
		playerView2.getLifecycleDelegate().releasePlayer(false);
	}

	@Override
	public void onSaveInstanceState(Bundle outState) {
		Bundle savedStateBundle = new Bundle();
		PlayerConfig playbackState = playerView1.getPlayerController().getPlayerConfig();
		if (playbackState != null) {
			playerView1.getPlayerController().getPlayerConfig().save(savedStateBundle);
			outState.putBundle(SAVED_PLAYBACK_STATE_BUNDLE_KEY1, savedStateBundle);
		}

		Bundle savedStateBundle2 = new Bundle();
		PlayerConfig playbackState2 = playerView2.getPlayerController().getPlayerConfig();
		if (playbackState2 != null) {
			playerView2.getPlayerController().getPlayerConfig().save(savedStateBundle2);
			outState.putBundle(SAVED_PLAYBACK_STATE_BUNDLE_KEY2, savedStateBundle);
		}
		super.onSaveInstanceState(outState);
	}
}
