package com.castlabs.sdk.conviva_demo;

import android.os.Build;

import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.ProcessLifecycleOwner;
import androidx.multidex.MultiDexApplication;

import com.castlabs.android.PlayerSDK;
import com.castlabs.android.drm.MemoryKeyStore;
import com.castlabs.demoutils.ActivityInsetManager;
import com.castlabs.sdk.conviva.ConvivaPlugin;
import com.castlabs.sdk.ima.ImaPlugin;
import com.castlabs.sdk.subtitles.SubtitlesPlugin;
import com.castlabs.logutils.Log;
import com.conviva.sdk.ConvivaAnalytics;
import com.conviva.sdk.ConvivaSdkConstants;

import java.util.HashMap;
import java.util.Map;

public class DemoApp extends MultiDexApplication implements LifecycleObserver {
	private static final String TAG = "DemoApp";
	private boolean appBackgrounded;

	@Override
	public void onCreate() {
		super.onCreate();
		registerActivityLifecycleCallbacks(new ActivityInsetManager());

		ProcessLifecycleOwner.get().getLifecycle().addObserver(this);

		Log.setLogLevel(android.util.Log.DEBUG);
		PlayerSDK.DEFAULT_KEY_STORE = new MemoryKeyStore();

		PlayerSDK.register(new SubtitlesPlugin());

		// Setup IMA plugin
		PlayerSDK.register(new ImaPlugin());
		ImaPlugin imaPlugin = PlayerSDK.getPlugin(ImaPlugin.class);
		if (imaPlugin != null) {
			imaPlugin.setEnabled(true);
		}

		// Create Conviva plugin with customer key
		ConvivaPlugin convivaPlugin = new ConvivaPlugin(C.CONVIVA_CUSTOMER_KEY);
		// Setup debugging options
		HashMap<String, Object> settings = new HashMap<>();
		settings.put(ConvivaSdkConstants.GATEWAY_URL, C.CONVIVA_TOUCHSTONE_GATEWAY);
		settings.put(ConvivaSdkConstants.LOG_LEVEL, ConvivaSdkConstants.LogLevel.DEBUG);
		convivaPlugin.setSettings(settings);

		// Setup custom device info (optionally), otherwise it is automatically collected by Conviva
		//convivaPlugin.setDeviceInfo(createCustomDeviceInfo());

		// Register plugin
		PlayerSDK.register(convivaPlugin);

		// Initialize the SDK
		PlayerSDK.init(getApplicationContext());
	}

	@OnLifecycleEvent(Lifecycle.Event.ON_STOP)
	public void onAppBackgrounded() {
		appBackgrounded = true;
		Log.d(TAG, "Report app backgrounded");
		ConvivaAnalytics.reportAppBackgrounded();
	}

	@OnLifecycleEvent(Lifecycle.Event.ON_START)
	public void onAppForegrounded() {
		if (appBackgrounded) {
			appBackgrounded = false;
			Log.d(TAG, "Report app foregrounded");
			ConvivaAnalytics.reportAppForegrounded();
		}
	}

	@NonNull
	private Map<String, String> createCustomDeviceInfo() {
		HashMap<String, String> deviceInfo = new HashMap<>();
		deviceInfo.put(ConvivaSdkConstants.DEVICEINFO.OPERATING_SYSTEM_VERSION, String.valueOf(Build.VERSION.SDK_INT));
		deviceInfo.put(ConvivaSdkConstants.DEVICEINFO.DEVICE_BRAND, Build.BRAND);
		deviceInfo.put(ConvivaSdkConstants.DEVICEINFO.DEVICE_MANUFACTURER, Build.MANUFACTURER);
		deviceInfo.put(ConvivaSdkConstants.DEVICEINFO.DEVICE_MODEL, Build.MODEL);
		return deviceInfo;
	}
}
