package com.castlabs.sdk.downloads;

import androidx.annotation.NonNull;
import androidx.multidex.MultiDexApplication;

import com.castlabs.android.PlayerSDK;
import com.castlabs.android.drm.SharedPreferencesKeyStore;
import com.castlabs.android.network.Request;
import com.castlabs.android.network.RequestModifier;
import com.castlabs.android.network.Response;
import com.castlabs.android.network.ResponseModifier;
import com.castlabs.demoutils.ActivityInsetManager;
import com.castlabs.sdk.downloader.DownloaderPlugin;
import com.castlabs.sdk.downloader.network.RequestModifierFilter;
import com.castlabs.sdk.downloader.network.ResponseModifierFilter;
import com.castlabs.sdk.subtitles.SubtitlesPlugin;
import com.castlabs.sdk.thumbs.ThumbsPlugin;

import java.io.IOException;


public class DownloadsApp extends MultiDexApplication {

	@Override
	public void onCreate() {
		super.onCreate();
		registerActivityLifecycleCallbacks(new ActivityInsetManager());

		// Setup the castlabs SDK and register the plugins used
		// by this demo.

		// We use the SharedPreferencesKeyStore to persist keySetIds in the Applications
		// shared preferences.
		PlayerSDK.DEFAULT_KEY_STORE = new SharedPreferencesKeyStore(this);

		// (Optional) Register the extended subtitles plugin
		PlayerSDK.register(new SubtitlesPlugin());

		// (Optional) Register the Thumbnail plugin
		PlayerSDK.register(new ThumbsPlugin(true));

		// Downloader plugin
		// (Optional) Add a RequestModifier or ResponseModifier to the Downloader plugin
		DownloaderPlugin.addRequestModifier(new RequestModifier() {
			@NonNull
			@Override
			public Request onRequest(@NonNull Request request) throws IOException {
				// Apply modifications to the request
				return request;
			}
		}, RequestModifierFilter.matchAll());
		DownloaderPlugin.addResponseModifier(new ResponseModifier() {
			@NonNull
			@Override
			public Response onResponse(@NonNull Response response) {
				// Apply modifications to the response
				return response;
			}
		}, ResponseModifierFilter.builder()
				//.downloadId("1")
				.build());

		PlayerSDK.register(new DownloaderPlugin(new NotificationProvider(), 10, DownloaderPlugin.STORAGE_LOW_MODE_QUEUED));

		// Initialize the SDK with all registered plugins
		PlayerSDK.init(getApplicationContext());
	}
}
