package com.castlabs.sdk.hdcp_demo;

import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.ProcessLifecycleOwner;
import androidx.multidex.MultiDexApplication;

import com.castlabs.android.PlayerSDK;
import com.castlabs.android.gstreamer.GStreamerPlugin;
import com.castlabs.demoutils.ActivityInsetManager;
import com.castlabs.logutils.Log;

public class DemoApp extends MultiDexApplication implements LifecycleObserver {

	@Override
	public void onCreate() {
		super.onCreate();
		registerActivityLifecycleCallbacks(new ActivityInsetManager());

		ProcessLifecycleOwner.get().getLifecycle().addObserver(this);
		Log.setLogLevel(android.util.Log.DEBUG);

		PlayerSDK.register(new GStreamerPlugin());
		PlayerSDK.init(getApplicationContext());
	}

}
