package com.castlabs.sdk.subtitle_styles;

import android.view.View;

import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;

import java.util.List;

/**
 * UIController used to update ExpandedControls's custom buttons state and visibility
 */
public class CustomUIController extends UIController {

	private View mView;

	public CustomUIController(View view) {
		mView = view;
	}

	@Override
	public void onMediaStatusUpdated() {
		// Update the state of mView based on the latest the media status.
		boolean enabled;
		switch (getRemoteMediaClient().getPlayerState()) {
			case MediaStatus.PLAYER_STATE_PLAYING:
			case MediaStatus.PLAYER_STATE_PAUSED:
				enabled = true;
				break;
			default:
				enabled = false;
		}
		mView.setEnabled(enabled);
		mView.setVisibility(View.VISIBLE);

	}
}
