package com.castlabs.sdk.subtitle_styles;

import android.content.Intent;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import android.view.View;

import com.castlabs.android.SdkConsts;
import com.castlabs.sdk.subtitles_styles.R;

public class MainActivity extends AppCompatActivity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		View settingsBtn = findViewById(R.id.settingsBtn);
		View playBtn = findViewById(R.id.playBtn);

		playBtn.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent intent = new Intent(MainActivity.this, SimplePlaybackDemo.class);
				intent.putExtra(SdkConsts.INTENT_URL, "http://demo.cf.castlabs.com/media/TOS/abr/Manifest_clean_sizes.mpd");
				intent.putExtra(SdkConsts.INTENT_PREFERRED_TEXT_LANGUAGE, "en");
				intent.putExtra(SdkConsts.INTENT_POSITION_TO_PLAY, 23 * 1000L * 1000L); // there are some subtitles at 23s
				startActivity(intent);
			}
		});

		settingsBtn.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent intent = new Intent(MainActivity.this, SettingsActivity.class);
				startActivity(intent);
			}
		});
	}
}
