/** add custom js here **/
/** hint: to load sphinx plugin JS, add a <script> in page.html instead */

/* global clSidenavSetup */

function clExternalLinks() {
  document.querySelectorAll('.reference.external').forEach(link => {
    link.target = '_blank'
  })
}

function clSetupMermaid() {
  const COLOR = {
    ASH: '#6d5e5e',
    BERRY: '#6e1c3b',
    BRICK: '#ba4f4f',
    CLAY: '#cfc8c8',
    EGGSHELL: '#fbf9f2',
    HAZE: '#eeece6',
    HONEY: '#dc9404',
    LEAF: '#53965d',
    NIGHT: '#262a35',
    ORCHID: '#b271bf',
    PETROL: '#096174',
    RED: '#fa423c',
    SAND: '#fdf5cf',
    SEA: '#5d9dd1',
    SKY: '#71c0ff',
    STEEL: '#a0a0a0'
  }

  mermaid.initialize({
    theme: 'base',
    themeVariables: {
      // global stuff
      fontFamily: 'NonNaturalGroteskInktrap, sans-serif',
      textColor: COLOR.NIGHT,
      lineColor: COLOR.ASH,
      mainBkg: COLOR.EGGSHELL,
      errorBkgColor: COLOR.EGGSHELL,
      errorTextColor: COLOR.BRICK,
      primaryColor: COLOR.CLAY,
      primaryTextColor: COLOR.NIGHT,
      primaryBorderColor: COLOR.NIGHT,
      noteBkgColor: COLOR.ASH,
      noteTextColor: COLOR.EGGSHELL,
      noteBorderColor: COLOR.ASH,

      // sequence diagrams
      actorBkg: COLOR.PETROL,
      actorBorder: COLOR.EGGSHELL,
      actorTextColor: COLOR.EGGSHELL,
      actorLineColor: COLOR.CLAY,
      activationBkgColor: COLOR.CLAY,
      activationBorderColor: COLOR.CLAY,
      signalColor: COLOR.ASH
    },
    sequence: {
      actorFontWeight: 700,
      actorMargin: 32,
      boxMargin: 8,
      boxTextMargin: 4,
      noteMargin: 8,
      messageMargin: 16
    }
  })
}

document.addEventListener('DOMContentLoaded', function () {
  clSidenavSetup()
  clExternalLinks()
  clSetupMermaid()
})
