package com.castlabs.sdk.broadpeak_demo;

import androidx.multidex.MultiDexApplication;

import com.castlabs.android.PlayerSDK;
import com.castlabs.demoutils.ActivityInsetManager;
import com.castlabs.sdk.broadpeak.BroadpeakPlugin;
import com.castlabs.sdk.thumbs.ThumbsPlugin;

public class DemoApp extends MultiDexApplication {
	private static final String TAG = "DemoApp";

	@Override
	public void onCreate() {
		super.onCreate();
		registerActivityLifecycleCallbacks(new ActivityInsetManager());
		final BroadpeakPlugin broadpeakPlugin = new BroadpeakPlugin(C.BROADPEAK_ANALYTICS_URL, null, "pf7.broadpeak-vcdn.com");

		// Optional: Enable Broadpeak ad tracking
		BroadpeakPlugin.adTracking = true;

		PlayerSDK.register(broadpeakPlugin);

		// Optional: Register the ThumbsPlugin to enable thumbnail support
		PlayerSDK.register(new ThumbsPlugin(true));

		PlayerSDK.init(getApplicationContext());
	}

	@Override
	public void onTerminate() {
		super.onTerminate();
	}
}
