package com.castlabs.sdk.hdcp_demo;

import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;

import androidx.appcompat.app.AppCompatActivity;

import com.castlabs.android.SdkConsts;
import com.castlabs.android.player.PlayerConfig;
import com.castlabs.android.player.BufferConfiguration;
import com.castlabs.android.player.CatchupConfiguration;
import com.castlabs.android.player.LiveConfiguration;

import java.util.concurrent.TimeUnit;

public class MainActivity extends AppCompatActivity {

	public static final String INTENT_PLAYLIST = "INTENT_PLAYLIST";

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		CatchupConfiguration catchupConfiguration = new CatchupConfiguration.Builder(CatchupConfiguration.TimeReference.BUFFER_AHEAD)
			.speed(500, 1200, 0, 1.15f)
			.get();
		LiveConfiguration liveConfiguration = new LiveConfiguration.Builder()
			.liveEdgeLatencyMs(240)
			.catchupConfiguration(catchupConfiguration)
			.get();
		BufferConfiguration bufferConfiguration = new BufferConfiguration.Builder()
			.minPlaybackStart(240, TimeUnit.MILLISECONDS)
			.minRebufferStart(240, TimeUnit.MILLISECONDS)
			.prioritizeTimeOverSizeThresholds(true)
			.lowMediaTime(120, TimeUnit.MILLISECONDS)
			.highMediaTime(12000, TimeUnit.MILLISECONDS)
			.get();

		PlayerConfig[] configs = new PlayerConfig[2];
		configs[0] = new PlayerConfig.Builder("192.168.88.254:4999")
			.contentType(SdkConsts.CONTENT_TYPE_GSTREAMER)
			.live(true)
			.liveConfiguration(liveConfiguration)
			.bufferConfiguration(bufferConfiguration)
			.get();
		configs[1] = new PlayerConfig.Builder("192.168.88.254:4998")
			.contentType(SdkConsts.CONTENT_TYPE_GSTREAMER)
			.live(true)
			.liveConfiguration(liveConfiguration)
			.bufferConfiguration(bufferConfiguration)
			.get();

		Bundle bundle = new Bundle();
		bundle.putParcelableArray(INTENT_PLAYLIST, configs);
		MainActivity.this.startActivity(new Intent(MainActivity.this,
			SingleControllerPlaylistDemo.class).putExtras(bundle));

		checkPermissions();
	}

	private void checkPermissions() {
		if (Build.VERSION.SDK_INT >= 23) {
			if (!(checkSelfPermission(Manifest.permission.ACCESS_COARSE_LOCATION) == PackageManager.PERMISSION_GRANTED)) {
				requestPermissions(new String[]{Manifest.permission.ACCESS_COARSE_LOCATION}, 0);
			}
		}

		if (Build.VERSION.SDK_INT >= 29) {
			if (!(checkSelfPermission(Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED)) {
				requestPermissions(new String[]{Manifest.permission.ACCESS_FINE_LOCATION}, 0);
			}
		}
	}

}
