package com.castlabs.sdk.mediasession_demo;

import android.app.Activity;
import android.net.Uri;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.castlabs.android.drm.Drm;
import com.castlabs.android.drm.DrmTodayConfiguration;
import com.castlabs.android.player.PlayerConfig;
import com.castlabs.android.player.PlayerView;
import com.castlabs.android.player.SingleControllerPlaylist;
import com.castlabs.logutils.Log;
import com.castlabs.sdk.mediasession.MediaSessionBuilder;
import com.castlabs.sdk.mediasession.MediaSessionPlugin;
import com.castlabs.sdk.playerui.PlayerControllerProgressBar;
import com.castlabs.sdk.playerui.PlayerControllerView;

public class ConcatenatingPlaybackDemo extends Activity {

	private static final String TAG = "ConcatenatingPlaybackDemo";

	private PlayerView playerView;
	private SingleControllerPlaylist playlist;
	private PlayerControllerView playerControllerView;
	private PlayerControllerProgressBar progressBar;

	private final PlayerConfig[] playerConfigs = new PlayerConfig[] {
		new PlayerConfig.Builder("http://demo.cf.castlabs.com/media/TOS/DASH/DEMO.mpd")
			.metaData(new BundleBuilder()
				.put(MediaSessionPlugin.METADATA_KEY_TITLE, "Item - 1")
				.put(MediaSessionPlugin.METADATA_KEY_ARTIST, "Artist - 1")
				.put(MediaSessionPlugin.METADATA_KEY_ARTWORK_URI, getResourceUri(R.drawable.castlabs))
				.get())
			.drmConfiguration(new DrmTodayConfiguration.Builder(
				DrmTodayConfiguration.DRMTODAY_STAGING,
				"purchase",
				"sessionId",
				"six",
				"dasheverywhere_demo",
				Drm.Widevine
			).get())
			.get(),
		new PlayerConfig.Builder("http://demo.cf.castlabs.com/media/bbb_abr/Manifest.mpd")
			.metaData(new BundleBuilder()
				.put(MediaSessionPlugin.METADATA_KEY_TITLE, "Item - 2")
				.put(MediaSessionPlugin.METADATA_KEY_ARTIST, "Artist - 2")
				.put(MediaSessionPlugin.METADATA_KEY_ARTWORK_URI, getResourceUri(R.drawable.castlabs))
				.get())
			.drmConfiguration(new DrmTodayConfiguration.Builder(
				DrmTodayConfiguration.DRMTODAY_PRODUCTION,
				"purchase",
				"default",
				"client_qa",
				"BBB_TEST",
				Drm.BestAvailable
			).get())
			.get(),
		new PlayerConfig.Builder("http://demo.cf.castlabs.com/media/shows/tos/Manifest.mpd")
			.metaData(new BundleBuilder()
				.put(MediaSessionPlugin.METADATA_KEY_TITLE, "Item - 3")
				.put(MediaSessionPlugin.METADATA_KEY_ARTIST, "Artist - 3")
				.put(MediaSessionPlugin.METADATA_KEY_ARTWORK_URI, getResourceUri(R.drawable.castlabs))
				.get())
			.drmConfiguration(new DrmTodayConfiguration.Builder(
				DrmTodayConfiguration.DRMTODAY_STAGING,
				"purchase",
				"p0",
				"six",
				"tos_next_gen_demo",
				Drm.Widevine
			).get())
			.get()
	};

	@Override
	protected void onCreate(@Nullable Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_simple_playback_demo);

		// Initialize the PlayerView
		playerView = findViewById(R.id.player_view);
		playerControllerView = findViewById(R.id.player_controls);
		progressBar = findViewById(R.id.progress_bar);
		playlist = new SingleControllerPlaylist(this, new PlaylistListenerImpl());
		playerView.setPlayerController(playlist);

		// Enable the media session
		MediaSessionBuilder mediaSessionBuilder = createMediaSessionBuilder();
		MediaSessionPlugin.enableMediaSession(playlist, mediaSessionBuilder);

		// Open the player
		openPlayer();
	}

	@Override
	protected void onStart() {
		super.onStart();
		playerView.getLifecycleDelegate().start(this);
	}

	@Override
	protected void onResume() {
		super.onResume();
		playerControllerView.bind(playerView);
		progressBar.bind(playlist);
		playerView.getLifecycleDelegate().resume();
	}

	@Override
	protected void onStop() {
		super.onStop();
		playerControllerView.unbind();
		progressBar.unbind();
	}

	@Override
	protected void onDestroy() {
		playerView.getLifecycleDelegate().releasePlayer(false);
		super.onDestroy();
	}

	private void openPlayer() {
		playlist.open(playerConfigs);
	}

	private MediaSessionBuilder createMediaSessionBuilder() {
		return new MediaSessionBuilder();
	}

	private Uri getResourceUri(int resourceId) {
		return Uri.parse("android.resource://com.castlabs.sdk.mediasession_demo/" + resourceId);
	}

	private static final class PlaylistListenerImpl extends SingleControllerPlaylist.AbstractPlaylistListener {
		@Override
		public void onItemChange(@NonNull PlayerConfig config) {
			Log.d(TAG, "onItemChange: " + config.contentUrl);
		}
	}
}
