package com.castlabs.sdk.mediasession_demo;

import android.content.Context;
import androidx.multidex.MultiDex;
import androidx.multidex.MultiDexApplication;

import com.castlabs.android.PlayerSDK;
import com.castlabs.android.drm.MemoryKeyStore;
import com.castlabs.android.network.Request;
import com.castlabs.android.network.Response;
import com.castlabs.demoutils.ActivityInsetManager;
import com.castlabs.sdk.debug.DebugPlugin;
import com.castlabs.sdk.mediasession.MediaSessionPlugin;
import com.castlabs.sdk.okhttp.OkHttpPlugin;
import com.castlabs.sdk.subtitles.SubtitlesPlugin;

public class DemoApp extends MultiDexApplication {
	private static final String TAG = "DemoApp";

	@Override
	public void onCreate() {
		super.onCreate();
		registerActivityLifecycleCallbacks(new ActivityInsetManager());

		// Setup the castlabs SDK and register the plugins used
		// by this demo.
		//
		// To demonstrate the license storage per application run,
		// we initialize the the default store to use an in memory store that
		// will not persistently store the keys. Consider using the SharedPreferencesKeyStore
		// to persist keySetIds in the Applications shared preferences or implement your own.
		PlayerSDK.DEFAULT_KEY_STORE = new MemoryKeyStore();

		// (Optional) Setup a KeyStore containing our trusted CAs
		// Use it only when really needed and be aware of the limitations,
		// see PlayerSDK.SSL_KEY_STORE for more details
		// PlayerSDK.SSL_KEY_STORE = createCustomSSLKeyStore();

		// (Optional) Use OkHttp and a custom client builder setup to allow debugging
		// network traffic
		PlayerSDK.register(new OkHttpPlugin());

		// (Optional) Register the extended subtitles plugin
		PlayerSDK.register(new SubtitlesPlugin());

		// (Optional) Enable MediaSession plugin
		PlayerSDK.register(new MediaSessionPlugin());

		// Register and the Debug plugin. NOTE: This is not intended to be used in production
		PlayerSDK.register(new DebugPlugin.Builder()
				.logOpenBundle(true)
				.logDownloadStarted(true)
				.logDownloadCompleted(true)
				.logDownloadCanceled(true)
				.logDownloadUpstreamDiscarded(true)
				.logDownloadError(true)
				.logVideoRendererEvents(true)
				.logPeriodInfo(true)
				.logSupportedDrm(true)
				//.logDecoderCounters(true)
				//.logTransferInfo(true)

				.logResponseType(Response.DATA_TYPE_DRM_PROVISION)
				.logResponseType(Response.DATA_TYPE_DRM_LICENSE)
				.logRequestType(Request.DATA_TYPE_DRM_PROVISION)
				.logRequestType(Request.DATA_TYPE_DRM_LICENSE)
				.logRequestType(Request.DATA_TYPE_MANIFEST)
				.logRequestType(Request.DATA_TYPE_SEGMENT)
				.logRequestType(Request.DATA_TYPE_OTHER)

				.enableRateLimiter(true, -1)
				.get()
		);

		// Initialize the SDK with all registered plugins
		PlayerSDK.init(getApplicationContext());
	}

	@Override
	protected void attachBaseContext(Context base) {
		super.attachBaseContext(base);
		MultiDex.install(this);
	}
}
