/*
 * Decompiled with CFR 0.152.
 */
package com.castlabs.android.drm;

import com.google.protobuf.nano.CodedInputByteBufferNano;
import com.google.protobuf.nano.CodedOutputByteBufferNano;
import com.google.protobuf.nano.InternalNano;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.google.protobuf.nano.MessageNano;
import com.google.protobuf.nano.WireFormatNano;
import java.io.IOException;
import java.util.Arrays;

public interface WidevineHeader {

    public static final class WidevineCencHeader
    extends MessageNano {
        public static final int UNENCRYPTED = 0;
        public static final int AESCTR = 1;
        private static volatile WidevineCencHeader[] _emptyArray;
        public int algorithm;
        public byte[][] keyId;
        public String provider;
        public byte[] contentId;
        public String trackType;
        public String policy;
        public int cryptoPeriodIndex;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WidevineCencHeader[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WidevineCencHeader[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WidevineCencHeader() {
            this.clear();
        }

        public WidevineCencHeader clear() {
            this.algorithm = 0;
            this.keyId = WireFormatNano.EMPTY_BYTES_ARRAY;
            this.provider = "";
            this.contentId = WireFormatNano.EMPTY_BYTES;
            this.trackType = "";
            this.policy = "";
            this.cryptoPeriodIndex = 0;
            this.cachedSize = -1;
            return this;
        }

        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.algorithm != 0) {
                output.writeInt32(1, this.algorithm);
            }
            if (this.keyId != null && this.keyId.length > 0) {
                for (int i = 0; i < this.keyId.length; ++i) {
                    byte[] element = this.keyId[i];
                    if (element == null) continue;
                    output.writeBytes(2, element);
                }
            }
            if (!this.provider.equals("")) {
                output.writeString(3, this.provider);
            }
            if (!Arrays.equals(this.contentId, WireFormatNano.EMPTY_BYTES)) {
                output.writeBytes(4, this.contentId);
            }
            if (!this.trackType.equals("")) {
                output.writeString(5, this.trackType);
            }
            if (!this.policy.equals("")) {
                output.writeString(6, this.policy);
            }
            if (this.cryptoPeriodIndex != 0) {
                output.writeUInt32(7, this.cryptoPeriodIndex);
            }
            super.writeTo(output);
        }

        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.algorithm != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size((int)1, (int)this.algorithm);
            }
            if (this.keyId != null && this.keyId.length > 0) {
                int dataCount = 0;
                int dataSize = 0;
                for (int i = 0; i < this.keyId.length; ++i) {
                    byte[] element = this.keyId[i];
                    if (element == null) continue;
                    ++dataCount;
                    dataSize += CodedOutputByteBufferNano.computeBytesSizeNoTag((byte[])element);
                }
                size += dataSize;
                size += 1 * dataCount;
            }
            if (!this.provider.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize((int)3, (String)this.provider);
            }
            if (!Arrays.equals(this.contentId, WireFormatNano.EMPTY_BYTES)) {
                size += CodedOutputByteBufferNano.computeBytesSize((int)4, (byte[])this.contentId);
            }
            if (!this.trackType.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize((int)5, (String)this.trackType);
            }
            if (!this.policy.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize((int)6, (String)this.policy);
            }
            if (this.cryptoPeriodIndex != 0) {
                size += CodedOutputByteBufferNano.computeUInt32Size((int)7, (int)this.cryptoPeriodIndex);
            }
            return size;
        }

        public WidevineCencHeader mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block13: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField((CodedInputByteBufferNano)input, (int)tag)) continue block13;
                        return this;
                    }
                    case 8: {
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: {
                                this.algorithm = value;
                            }
                        }
                        continue block13;
                    }
                    case 18: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)input, (int)18);
                        int i = this.keyId == null ? 0 : this.keyId.length;
                        byte[][] newArray = new byte[i + arrayLength][];
                        if (i != 0) {
                            System.arraycopy(this.keyId, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readBytes();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readBytes();
                        this.keyId = newArray;
                        continue block13;
                    }
                    case 26: {
                        this.provider = input.readString();
                        continue block13;
                    }
                    case 34: {
                        this.contentId = input.readBytes();
                        continue block13;
                    }
                    case 42: {
                        this.trackType = input.readString();
                        continue block13;
                    }
                    case 50: {
                        this.policy = input.readString();
                        continue block13;
                    }
                    case 56: 
                }
                this.cryptoPeriodIndex = input.readUInt32();
            }
        }

        public static WidevineCencHeader parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return (WidevineCencHeader)MessageNano.mergeFrom((MessageNano)new WidevineCencHeader(), (byte[])data);
        }

        public static WidevineCencHeader parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WidevineCencHeader().mergeFrom(input);
        }
    }
}

