# 4.4.8

---
## Changed

* Fixed an issue which provoked Youbora metadata not to update when reusing the same 
 ``PlayerController`` instance to play a different item.
* Updated Youbora to version 7.3.23

# 4.4.7

---
## Changed

* Added a Default VAST Load timeout of 4 Seconds and an AD Media Load Timeout of 6 seconds to trigger
  IMA Errors when no timeouts are specified.
* Fixed regression introduced in 4.4.3: ``DrmLicenseLoader.fetchLicense`` throwing 
 ``IllegalStateException`` when using ``OkHttpPlugin``.
* Fixed video quality dropping to lowest when changing playback speed without explicit
 ``TrickplayConfiguration``. ABR now correctly remains active when ``preferTrickPlayTracks``
 is disabled (the default) (**Behaviour Change**). ABR is disabled in
 ``SpeedupMode.SEEK`` (**Behaviour Change**).
* Fixed a potential crash in tunneled video playback when reinitializing the codec.
* Updated muxcore to 8.7.0
* Updated Google IMA SDK to 3.37.0 (**Breaking Change**): Applications using the IMA plugin
 now require core library desugaring to be enabled. See the Extensions manual section for complete
 setup instructions.

## Added

* Added integration of Mux analytics with ``SingleControllerPlaylist``.
* Added ``PlaylistException`` for improved error handling in ``SingleControllerPlaylist``.
  See the SingleControllerPlaylist section in the manual for details.

# 4.4.6

---
## Changed

* Fixed ``Conviva`` average bitrate reporting when using ``SingleControllerPlaylist`` with live
  streams.
* Updated Youbora to version 7.3.18
* Fixed an fatal error occurring when a UTC timing element was resolved after ``PlayerController`` release 
 during DASH playback.
* Fixed handling of AD Response Group timings to Double from Integer to accomodate streams with millisecond 
 level precision.
* Fixed regression introduced in 4.4.5: Widevine playback failures on some devices where Widevine 
 was incorrectly reported as unsupported.
* [Experimental] Added Support for Widevine and Playready encrypted E-AC3 Multicast Content.
  This method of encryption uses a Castlabs specific `Encryptor` at the IPTV Client Headend.

# 4.4.5

---
## Added

* Expose DRMToday ``traceId`` through `DrmTodayException#getTraceId()`. This might result useful for
  debugging or analytics. Check the manual at the DRM Protection > Troubleshooting section.
* Added ``BandwidthResetMode`` in ``SingleControllerPlaylist``. This allows the playlist to reset
  the current bandwidth estimation to its initial value automatically upon item transition.
* [Experimental] Added Support for Widevine and Playready encrypted AAC-ADTS, AAC-LATM and AC3 Multicast Content. 
  This method of encryption uses a Castlabs specific `Encryptor` at the IPTV Client Headend.
* Added ability to control ``PlayerSDK.AUDIO_CODEC_FILTER`` behavior independently from Video, similar to
  ``PlayerSDK.VIDEO_CODEC_FILTER``. The default value of the same is set to ``SdkConsts#AUDIO_CODEC_FILTER_CAPS``.
* Added ``PlayerSDK.AD_SETTINGS`` to configure ad playback behavior. The ``creativeFormatFallback``
  setting allows specifying a fallback format (Progressive, HLS, DASH, etc.) for ad creatives when the
  format cannot be detected from the URI. By default, ad creatives without detectable formats will
  now fallback to Progressive (**Behaviour Change**).
* Added support for Broadpeak Server-Side Ad Insertion (SSAI) streams. Check the Broadpeak section
  in the Extensions part of the manual for more information.

## Changed

* Improved DRM initialization performance.
* ``DrmUtils`` API Updates: `DrmUtils.getSupportedDRM()` now returns `Set<Drm>` instead of `List<Drm>`.
 `DrmUtils.selectBestDrm` has been renamed to `DrmUtils.selectBestDrmExcluded`.
* Guard ``MediaDrm`` release calls as some devices might kill the internal media service and provoke
 an internal unexpected NPE.
* Broadpeak: fixed potential ANR and improved session renew flow upon VoD playback to completion.
* Fixed potential fatal MediaSession handling
* Updated Broadpeak's smartlib to version 05.03.01.

# 4.4.4

---
## Added

* [Experimental] Added Support for Widevine encrypted H264 and Widevine encrypted H265-HEVC Multicast Content. This method of 
 encryption uses a Castlabs specific `Encryptor` at the IPTV Client Headend.

## Changed

* Fixed a rare potential crash when activating a track selection while releasing the player.
* Fixed handling of EventStreams when the same is not in the Manifest at Join Time, causing
 CUE_START and CUE_END events to be missed.

# 4.4.3

---
**Changes**
* Added support for configuring a series of IMA parameters in the ``ImaAdRequest.Builder``;
 ``PlayAdsAfterTime``, ``AdPreloadTimeout``, ``VastLoadTimeout``, ``MediaLoadTimeout``,
 ``MaxMediaBitrate`` and ``PlayAdBeforeStartPosition``.
* Added `PlayerSDK.ANALYTICS_SETTINGS` to customize the labels sent by the supported Analytics providers.
 Labels for DRM names and disabled audio and text can be customised.
* Added automatic fallback when audio passthrough output is changed.
* Fixed a stacktrace-printing error that could happen when releasing the player when it was still  
 processing ``ThumbnailTracks``.
* Fixed an issue where the IMA ad overlay could remain visible after releasing and reopening
 the player while preserving the view surface.
* Broadpeak: Improved session release flow. Fixed potential ANRs when Broadpeak's Smartlib was unresponsive.
* Added thumbnail disk cache configuration via ``ThumbsPlugin.setDiskCacheMode(...)``.
 Caching is turned off by default now (**Behaviour Change**).
* Fixed an issue when using `Conviva` analytics alongside ``SingleControllerPlaylist`` which provoked
 subsequent views not to include media player framework information.
* Fix MediaSession data not properly updating when opening a new item on the ``PlayerController``.
* Added Request/Response modifier filters to the ``DownloaderPlugin`` so custom network hooks can
 target specific download ids when adjusting headers or payloads.

# 4.4.2

---
**Changes**
* Added ``SubtitlesStyle.TEXT_ALIGN_AUTO`` and ``SubtitlesStyle.DISPLAY_ALIGN_AUTO`` options to
 control horizontal and vertical subtitle alignments when font size or scale is changed.
* Deprecated ``SubtitlesStyle.disableAutoFlowText`` and ``SubtitlesStyle.regionAutoSizedToFit`` (**API Change**)
* Fixed an issue in the ``ThumbsPlugin`` which prevented some of the ``Wave``s defined
 in the ``LoadingStrategy`` to be cached in background.
* Added ``ThumbsPlugin.DEBUG`` flag to enable detailed logging of thumbnail loading.
* Fixed memory leak caused by ``DebugPlugin`` Overlay.
* Reworked ``DebugPlugin`` (**API Change**) (**Behaviour Change**). Some setter methods now are not 
 applying at runtime anymore. Check the API docs for details on how to apply. ``showDebugOverlay`` and
 ``hideDebugOverlay`` have been removed from ``DebugPlugin`` and alternative APIs are in ``OverlayControllerComponent``.
* Improved ``DownloadService`` stability when started from background on devices with strict 
 background execution limits. 
* Added static configuration in Exo to detect Renderer stall and seek if needed

# 4.4.1

---
**Changes**
* Fixed an issue where recoverable player errors would disconnect the media session.
* Automatically disconnect the Player from the media session upon fatal error
* Fixed an error where some downloads present before version 4.4.0 could not be handled by the SDK.
* Added DASH audio channel configuration parsers. 
* Fixed incorrect handling of ``DownloadService`` timeouts on Apps targeting API 35+. 
* Added a new ``ACTION_DOWNLOAD_SERVICE_TIMEOUT`` message fired from `DownloadService` via `MessageHandler`
 when `onTimeout` is triggered.
* Added ``ThumbsPlugin.EMPTY_LOADING_STRATEGY``. Use this strategy if you want to disable any 
 precaching of thumbnails while still being able to load them on demand.

# 4.4.0

---
**Changes**
* The minSdk has been increased from 16 to 21 (Android 5.0 Lollipop).
* Added compatibility for 16KB native page alignment
* OMA DRM plugin is deprecated and removed (**API Change**)
* Updated ``Project Configuration`` section in documentation with the SDK remote repository
* Updated ``BroadpeakPlugin`` to 05.02.01
* Improved ``BroadpeakPlugin`` metadata creation by introducing a ``MetadataBuilder`` and
 deprecating the static ``createMetadata`` methods. It also allows to disable Broadpeak
 precache for each session.

# 4.3.2

---
**Changes**
* Fixed an issue when DRM session maybe closed while still in use
* Fixed an issue with closed DRM session when using ``preservePlayerResources`` upon ``PlayerController`` release
* ``RequestModifier`` and ``ResponseModifier`` for the ``DownloaderPlugin`` will now
 also be triggered for DRM requests.
* Fixed Issue in MediaCodecRenderer in playlists and PlayerPreserve scenarios where the CryptoInfo
 clear size of first sample is not increased during Decoder Reconfiguration with CSD/Initialization
 data.
* Updated Conviva to 4.0.46
* Integrate Conviva with ``SingleControllerPlaylist``

# 4.3.1

---
**Changes**
* Updated Youbora to version 7.3.6
* Fixed an issue when ``PlayerSDK.VIDEO_CODEC_BUFFER_MODE`` override is ignored. Regression since 4.2.88
* Added ``SubtitlesStyle`` options ``regionAutoSizedToFit``, ``textAlign`` and ``displayAlign`` to control 
text placement when font size is overridden
* Fixed issue where for Fast Zaps in playlists Mediacrypto is created but Codec is not and playback 
doesnt start
* Fixed Context leak upon releasing a Youbora Session when the SDK was not the owner of the ``NpawPlugin`` instance

# 4.3.0

---
**Changes**
* OMA DRM Plugin is deprecated and will be removed in an upcoming version. `Drm.BestAvailable` now
 won't select OMA as a DRM system.
* Fixed an issue where the player might not select a video track upon playlist transitions.
* Updated Conviva to 4.0.44
* Media Session Plugin migrated to use Media3 libraries. (**API Change**)
* Fixed wrong processing of stale DRM sessions
* Fixed an issue provoked by ``DrmTimingComponent`` under certain circumstances when repeatedly calling
 playlist operations
* Fixed an issue with the Downloader when trying to download some DASH streams with multiple audio tracks

# 4.2.91

---
**Changes**
* Revert minimum kotlin version dependency to 1.7
* Fixed an incorrect link in the documentation.

# 4.2.90

---
**Changes**
* Added ``RequestModifier.Listener`` to get ``onUriChanged`` callbacks, attach with ``PlayerController.addRequestModifierListener``.
* Added Callback ``onThumbnailLoadError`` for Thumbnail Loading Errors 
* Fixed an issue when ``VideoRendererListener.onVideoDecoderReleased`` is invoked with null codecName
* Removed ``debug_plugin`` dependency on legacy compat libs and do not enable jetifier for it
* Fixed Memory Leak in PlayerView Class
* Added CMCD Support Documentation
* Fixed DRM Session leak when using ``preservePlayerResources`` upon ``PlayerController`` release.
* Improved player robustness when ``preservePlayerResources`` is enabled.
* Integrated ``DownloaderPlugin`` with ``RequestModifier`` and ``ResponseModifier``. Check the
 Downloader section in the manual for more information.

# 4.2.89

---
**Changes**
* Added ``DateRange`` for HLS streams inside ``Period``. This is exposed in the ``Timeline`` object
 passed to the ``TimelineChangedListener`` and ``InitialPositionProvider`` interfaces.
* Fixed an issue when custom ``NetworkConfiguration`` is not applied to ``SingleControllerPlaylist``
* Added ``PlayerController.release`` with parameters to control and override ``preservePlayerResources`` and
``preservePlayerViewSurface`` in ``PlayerConfig``.
* Fixed an issue in TTML subtitles where spaces inside child tags were not rendered correctly.
* Fixed a crash with Subtitles Native Plugin when duration is set to 0

# 4.2.88

---
**Changes**
* Fixed an issue where adding an item to ``SingleControllerPlaylist`` (when it previously contained
 only one item) and then immediately removing the current item caused the player to briefly enter
 the ``Finished`` state before starting playback of the new item.
* Fixed an issue in DASH streams where divide by zero error occurred when the segment duration is unset.
* Fixed issue which provoked some HLS streams with variants to get stuck upon playback start or not buffer at all
* Fixed an issue when playback may stall upon DASH manifest transition from dynamic to static
* Fixed an issue when metadata renderer may stall the playback
* Added AV sync measurements in ``DebugPlugin``, see more details in Player Debugging, section AV Sync
* Fixed an issue when exception may not be raised upon transitioning to the failed item in ``SingleControllerPlaylist``
* Added Period, start time and ``PlayerConfig`` information to timeline ``Window``s.
* Added ``EventMessagesListener`` to receive updates about the event messages in the stream.

# 4.2.87

---
**Changes**

* Fix for BehindLiveException when zapping through LIVE channels using SingleControllerPlaylist
* Added ``DrmConfiguration.preferManifestUrl`` and default ``PlayerSDK.DEFAULT_DRM_PREFER_MANIFEST_URL`` 
options to control the priority of ``dashif:Laurl`` (**API Change**)
* Increase Max Codec Size value for Hevc content
* Added ``PlayerConfig.preservePlayerResources`` option to allow ``PlayerController`` holding resources such
as video decoders, track selectors etc. By doing so, the player maybe able to reduce latency when starting another 
content and also preserve the last video frame when combined with ``PlayerConfig.preservePlayerViewSurface``. The 
application is then responsible to free the resource with ``PlayerController.destroy``, 
if not using ``PlayerViewLifecycleDelegate``.
* Added ``VideoRendererListener.onVideoDecoderReleased`` event (**API Change**)

# 4.2.86

---
**Changes**

* Fix to avoid freeze when total number of ADs in a Pod unexpectedly decrements without notification
* Added support for ``dashif:Laurl``. In this case ``DrmConfiguration`` may not be provided to the player at all,
as it does not require to have any DRM URL. When ``DrmConfiguration`` is provided and it contains DRM URL then it overrides ``dashif:Laurl``,
check the manual for more details in DRM Protection, section DRM URL.
* Added customizable ``PlayerSDK.DEFAULT_DRM_CONFIGURATION`` to configure DRM when the one is not provided by the application.
* Added ``DrmConfiguration.Builder`` as a better way to create ``DrmConfiguration``.
* Fix DASH thumbnail URL calculation for live streams with an explicit ``SegmentTimeline`` and a low or undefined ``startNumber``
* Error message for the Broadpeak Plugin includes the error codes when the session URL is not available.
* Log Trace ID for DrmToday Requests.
* Fix an issue where the ABR selection is not stable near live edge.
* Fixed ``onCueEnd`` not being triggered for DASH EventStreams under some circumstances.

# 4.2.85

---
**Changes**

* Fixed memory leak in ``PlayerController`` release, introduced in 4.2.78
* Changed default of ``PlayerSDK.VIDEO_CODEC_FILTER`` from ``VIDEO_CODEC_FILTER_NONE`` to ``VIDEO_CODEC_FILTER_CAPS``.
This is to prevent playback exception on devices not capable of decoding high-resolution videos. (**Behaviour Change**)
* Added mapping of new DrmToday error codes to ``DrmTodayException.ErrorCode``
* Fixed an issue where MP4-VTT subtitles disappeared after seeking to a different position.
* Fixed an issue where download is not cancelled when the segment download size is not available.
* Apply FireTV media codec workaround to other types of devices, reverted to 4.2.82 (**Behaviour Change**)
* Removed unneeded Youbora library.

# 4.2.84

---
**Changes**

* Added GStreamer plugin
* Fixed an issue when ``IndexOutOfBoundsException`` maybe raised by ``DebugPlugin``
* Thumbnail loading Waves have now a fixed phase. This prevents sparse Waves in live streams from
 referencing more thumbnails than they should over time.
* Updated to MuxCore 8.1.2
* Added playback recovery when passthrough audio fails due to changed output audio capabilities,
see also configuration parameter ``PlayerSDK.ENABLE_INVALIDATE_SELECTION_ON_RENDERER_CAPS_CHANGED``.
* Added audio renderer events in ``DebugPlugin``, configurable with ``logAudioRendererEvents`` and 
``logDecoderCounters``.
* Fixed an issue when Widevine DRM exception maybe raised on devices with API >= 34 and OEMCrypto code = 29
* Implemented the report of the Seeking event for Mux.
* Improvements in audio buffer size when the audio mode is passthrough.
* Fixed an issue in subtitles plugin when R8 was enabled.
* Updated Youbora to version 7.2.40. This also fixed an issue in Youbora plugin when R8 was enabled.
* Fixed runtime error when using the googlecast_plugin and setting targetSdk 34.

# 4.2.83

---
**Changes**

* Added the flag ``FATAL_ERROR_ON_SECONDARY_DISPLAY_NOT_ALLOWED`` to the ``PlayerSDK``. The default
 value is true. If set to false, then no fatal error is raised when trying to connect to the
 secondary display while not permitted.
* Adding ``allowMultiTrackVideoSelection`` method to ``PlayerControllerView`` in Player-UI Plugin to enable the selection of video tracks.
* Improved the robustness of subtitle selection
* Additional fixes for live DASH thumbnail URL calculations when the ``AdaptationSet`` specifies a
 ``startNumber`` within the live Window.
* Fixed a subtitle crash issue when R8 is enabled.
* Fixed an issue when audio decryption error may not be raised.
* Fixed an issue when a trickplay video track with all its qualities disabled is selected for playback.
* Added ``getCuePointsList`` and ``getThumbnailPosition`` to the ``ThumbnailProvider``. The first one returns
 actual positions of the thumbnails in a list and the second one returns a thumbnail position close to the
 requested position.
* Added Flag ``preferLatencyOverBufferSafety`` as a ``LiveConfiguration`` for streams that support Low Latency.
 This configuration can cause further delay in stream loading since we attempt to seek closer to the Live Edge when 
 specified. 
* Add ``ThumbnailProvider.cancelRequests`` method to cancel explicit queued Requests. Note that this
 won't cancel any already in-flight request.
* The content type of M4A and M4V is now automatically detected, eliminating the need for manual definition.
* Removed ``ChannelsPlugin``. If similar functionality is required, migrate to using the ``MultiControllerPlaylist``.
* Stability and performance improvements in ``StandaloneThumbnailProvider``.
* ``StandaloneThumbnailProvider`` will now update its internal thumbnail index if a live stream 
 is used. Additionally, an ``IndexRefreshListener`` can be added to the ``ThumbnailProvider`` to
 get notified when such a refresh takes place.
* Added missing javadoc documentation for the Subtitles Styles API. 
* Improved Ad API. ``AdInterface`` has new events: ``adPaused``, ``adResumed`` and ``adClicked`` methods.
 ``Ad`` now contains info about the ad pod it belongs to.
* Updated Youbora integration to version 7.2.38.
* Updated Broadpeak's smartlib to version 05.00.03.

# 4.2.82

---
**Changes**

* ``DashEventStreamListener`` is renamed to ``EventStreamListener``. Also the ``addDashEventStreamListener``
 method of the PlayerController is renamed to ``addEventStreamListener``. No flag is needed to enable this
 listener and it is enabled by default. (**API Change**)
* Fixed an issue with ``InitialPositionProvider`` when repeated playback of the first item starts from the provided position
 and not from the default one.
* Added ``PlayerSDK.PLAYBACK_POSITION_PERIOD_MS`` to customize the interval of playback position updates (**API Change**)
* ``EventStreamListListener`` is added to provide all the events corresponding to the event-streams
 as a list. This listener could be added by the ``addEventStreamListListener`` method of the PlayerController.
* Added ``RequestQueuePosition`` for ``ThumbnailProvider``. By setting the ``RequestQueuePosition`` to ``AddFront``, 
 thumbnail requests will be enqueued at the beginning of the loading queue.
* Improved the stability of ``ThumbnailProvider``.
* Fixed wrong DASH thumbnail URL calculation for live streams. Regression introduced in 4.2.81. 
* Fixed exception in ``DebugPlugin`` when ``logTimingDebugInfo`` is enabled for ``SingleControllerPlaylist`` playback
* Fixed issue with foreground service for background playback.
* Improved stability of AudioFocusManager when opening playback

# 4.2.81

---
**Changes**

* Fixed an issue when exception with ``TYPE_DRM_EXCEPTION`` maybe raised instead of ``TYPE_KEY_EXPIRED``
* Fixed the crash issue on Android 14 (API 34) when using mediasession-plugin. The ``minSdkVersion`` is 
also changed for this plugin to ``19``.
* Fixed an issue when the last subtitle shown twice in some cases.
* Fixed an issue when the thumbnail position was incorrect is some cases. Segment and period durations
 in ``ThumbnailDataTrack`` are in microseconds now (**API Change**)
* ``InitialPositionProvider`` is re-used by ``PlayerController`` until the latter is destroyed (**Behaviour Change**)
* Fixed an issue when no error called for SSL certificate error for ``SdkConsts.CONTENT_TYPE_MP4``.
* Back Ported support for CMCD Logging and passing CMCD Configurations for HLS, Dash and SS.

# 4.2.80

---
**Changes**

* Added support for forced subtitles in DASH streams.
* Output a warning a log message instead of throwing a ``WARNING`` error when no renderers are found
 for a particular media type.
* Added support for TTML2 textShadow.
* Properly account for player Views upon each ``SingleControllerPlaylist`` item change.

# 4.2.79

---
**Changes**

* Fixed stability issues around ``SingleControllerPlaylist``.
* Fixed an issue when key ids added to ``MemoryKeyStore`` do not depend on its life cycle (**Behaviour Change**)
* Added ``PlayerSDK.SEEK_MODE`` and ``PlayerController.setPosition`` to control player seeking mode.
* Added ``InitialPositionProvider.snapToSegmentStart`` to snap to the previous sync point (**API Change**)
* ``disableAutoFlowText`` property is added to the ``SubtitlesStyle`` and If set to true the auto-flow text
behaviour will be disabled regardless of the font-size and the font-scale.
* Added Media MimeType reporting for ``VideoTrackQuality``, ``AudioTrack`` and ``SubtitleTrack``. This
 informs about the *media* mime type in opposition to the *codec* mime type which was already present in the model.
* Fixed an issue when subtitles disappear on seek back from position set by ``InitialPositionProvider``.
* Fixed codec retention for devices with API <= 22 (regression since 4.2.74) and unsecure codecs.
* Fixed potential memory leak provoked by background Thumbnail loader threads.
* Fixed track selection failing to select a video track under some circumstances upon rental DRM license expiration
* Added ``StandaloneThumbnailFactory`` to enable fetching of Thumbnails outside of a playback session.
 Check the manual for more information in Extensions, Thumbnails, Standalone Thumbnail providers.

# 4.2.78

---
**Changes**

* Do not include back buffer duration into audio and video buffer calculations, affects ``LoadControlListener`` (**Behaviour Change**)
* Add possibility to fully customize the user-agent.
* Add ``DashEventStreamListener`` which is responsible to deliver cue-start and cue-end events
corresponding to ``EventStream`` in DASH manifest.
* Upgrade Conviva SDK and fix issues.
* Added experimental feature to disable video qualities causing video frame drops, see ``Video quality blocklist`` section (**Behaviour Change**)
* ``adWillStart`` event is added to the ``AnalyticsSession`` and ``AdInterface`` and is called when
the ad starts loading. (**API Change**)
* Added ``ThumbnailProvider.getThumbnail`` API working with ``Future``.
* Fixed an issue when secondary display restrictions are not applied by reused ``PlayerController``

# 4.2.77

---
**Changes**

* Fixed an issue with ``SingleControllerPlaylist`` which sometimes provoked erroneous item transitions
 upon removing the last playlist item while it was playing.
* Fixed exception when informing a null ``CatchupConfiguration``.
* Fixed a thumbnail issue where the returned thumbnail time differed from the requested thumbnail
time by more than the allowed tolerance.
* ``MultiControllerPlaylist`` can now seek to each PlayerConfig's default position on item transition
 by setting ``seekToDefaultPositionOnItemChange`` to ``true`` in ``MultiControllerPlaylist.Builder``.

# 4.2.76

---
**Changes**

* Added configurable timeouts for thumbnails.
* Fixed an issue when subtitles rendering maybe delayed with enabled flag ``BufferConfiguration.prioritizeInstreamOverManifestDuration``.
* Fixed NPE when downloading content with HTTP redirects.
* Made Decoder Input Buffer Replacement Behavior configurable via workaround
* Add Changes to allow transfer listener to listen to bytes transferred in IPTV DataSource
* Added Surface Change FrameRate Strategy with default set to VIDEO_CHANGE_FRAME_RATE_STRATEGY_ONLY_IF_SEAMLESS (**Behaviour Change**)
In order to revert to not setting Surface Framerates you may disable it by setting ``PlayerController.setChangeFramerateStrategy`` to
``VIDEO_CHANGE_FRAME_RATE_STRATEGY_OFF``. Applications wishing to use ``Surface#CHANGE_FRAME_RATE_ALWAYS`` should set the mode to
VIDEO_CHANGE_FRAME_RATE_STRATEGY_OFF to disable calls to Surface#setFrameRate from the player, and should then call Surface#setFrameRate
directly from application.
* Updated Broadpeak's smartlib to version 04.07.03.
* Extended Broadpeak integration to handle multiple sessions while using ``SingleControllerPlaylist``.
* ``RequestModifier``s can now throw an ``IOException`` when modifying the ``Request``.
* Fixed an issue introduced in 4.2.74 when player may fail to transition from IMA ads to content.

# 4.2.75

---
**Changes**

* Fixed an issue when Drm key status of video qualities is reported as ``Unknown`` while playing streams
with no DRM data in the manifest.
* Downloader compatibility for API 33+
* Updated Proguard Rules for Subtitles Base Plugin
* Added IMA Custom UI Support
* Thumbnails: fixed an issue when trying to iterate over a ``TimeWave`` with a period larger than 
 gap between thumbnails.
* Two methods ``onPositionFramesMismatch`` and ``onSystemTimeUsMismatch`` are added to the
``AudioRendererListener`` in order to notify audio mismatch events. (**API Change**)
* Added ``BufferConfiguration.prioritizeInstreamOverManifestDuration`` flag to control whether the loader 
calculates the buffered duration based on the manifest (e.g. duration tags) or audio/video segment durations.
The default is to use the audio/video segment durations (**Behaviour Change**)
* Fixed an issue when playback is transitioned to the next protected item in ``SingleControllerPlaylist`` with disabled audio or video track.
* Added ``LoadControlListener`` to listen to load control events and integrated it with ``DebugPlugin``
* ``subtitleSubSampleType`` is added to the ``PlayerConfig``. It could be ``SUBTITLE_SUB_SAMPLE_TYPE_ABSOLUTE``
or ``SUBTITLE_SUB_SAMPLE_TYPE_RELATIVE``, and defines whether the subtitle times are absolute or relative.
* Fixed an issue for WebVTT subtitles when embedded in a Mp4 container file.

# 4.2.74

---
**Changes**

* Fixed an issue when mistakenly reusing DRM sessions for different DRM schemes.
* Fixed DRM key rotation, see details in section ``Key rotation`` of the manual.
* Improved codec retention when changing DRM sessions to ensure smooth playback.
* Fixed DASH parser when ``ContentProtection`` element does not contain any key data.

# 4.2.73

---
**Changes**

* Fixed regression when playback in tunnelling mode can not be started on devices with API >= 23 
* Subtitle Presentation, Log and Subtitle Base are now moved out of Prestoplay since they are common 
dependencies for the TV SDK. This should be purely an internal change, however the App must ensure 
that these AARs are included in their final Apk.
* Update RTP Implementation with RTCP Support
* Support for Teletext Subtitles(IPTV TS Playback) when PTS is out of range
* Fixed an issue when the app is put to the background and brought to the foreground after a few
minutes during the pre-roll.
* Added a new error: ``TYPE_TUNNELING_ERROR`` raised as a warning when tunneling mode can not be enabled
and the playback continues in non-tunneling mode (**API Change**)
* Improved behaviour of ``ThumbnailProvider.getThumbnail``: now thumbnails will always be resolved
 precisely, multiple calls can be invoked in parallel without waiting for preceding ones and callbacks
 will always be invoked, even if the data couldn't be fetched or the request gets cancelled. Explicit
 thumbnail requests will also take precedence and prioritized over the background thumbnail loads.
* Added multithreaded Thumbnail loading. Default is 2 threads. Configurable via
 ``ThumbsPlugin.setThumbnailLoadThreads`` before playback start.

# 4.2.72

---
**Changes**

* Thumbnail loading order now prioritizes the current playback position.
* Player release and Surface setting timeouts. This helps avoiding ANRs as a workaround in case an
 underlying component, such as a decoder, is unresponsive. Timeouts are configurable through ``PlayerSDK``.
* Fixed an issue where the ``CatchupConfiguration`` might be applied to VoD streams if using ``SingleControllerPlaylist``.
* Fixed ``PlayerController``'s ``isLive`` method. It previously reported whether the current Window
  was expecting a manifest update, which didn't necessarily represent whether a stream was live or not. (**Behaviour Change**)

# 4.2.71

---
**Changes**

* [IPTV] Sync -Ensure Audio of content is only passed after Video even if Audio is ahead.
* Playback will be paused if all the qualities are not playable due to HDCP restrictions (**Behaviour change**)
 Use ``PlayerSDK.PAUSE_ON_HDMI_DISCONNECTED`` or ``SdkConsts.INTENT_PAUSE_ON_HDMI_DISCONNECTED`` to change 
 default behaviour.
* Fix Race Condition in Single Controller PlayList most seen with IPTV Playback
* Fixed ``liveEdgeLatency`` not taking effect for live HLS streams. If informed, it will take precedence
  over ``hlsLiveTailSegmentIndex``.
* Added response headers to ``StreamingEventListener`` methods. (**API Change**)
* Fix Mux issue for reporting CDN value.
* SingleControllerPlaylist: apply each item's live configuration.
* SingleControllerPlaylist might alter the configurations passed in to the ``open`` method. This
 implies that all APIs which operate on ``PlayerConfig`` instances will do so in relation to what's
 currently in the playlist, as provided by ``getPlaylist()`` (**Behaviour change**)
* Added API to change the thumbnails ``LoadingStrategy`` after plugin initialization.
* Fixed thumbnails not starting to immediately load when the load start delay was set to ``0``. 

# 4.2.70

---
**Changes**

* Added ``onPlaylistEnded`` method to SingleControllerPlaylist.PlaylistListener. (**API Change**)
* Improved handling of Discontinuity in Multicast Streams where Audio is ahead and made it configurable
* Added support for bandwidth estimation parsing out of CMSD headers. This feature has to be enabled
 in the ``AbrConfiguration``.
* Fixed ``ResponseModifiers`` not accumulating modifications from successive modifiers.
* Added ``HybridController`` support to enable DVB/IPTV playback with WVCAS Support. This requires the 
 device to be TunerFramework compatible. This also requires the CastLabsServiceApplication to be installed 
 on the device /system/priv-app folder which requires System privileges to operate. Example usage can be 
 found under the examples/hybrid_demos application.
* Fixed ``PlayerController`` deadlock when calling ``release`` when transitioning to ``Preparing`` state.
* Fixed potential ANR when releasing the ``PlayerController`` during thumbnail loading
* When using the ``MultiControllerPlaylist`` the analytics data reports only for the current item. This behavior
could be changed by setting the flag ``MultiControllerPlaylist.justEnableAnalyticsForCurrentItem`` to false, which
is true by default.
* Fixed an issue when handling non-absolute redirect locations in the ``OkHttpPlugin``.
* Added workaround to avoid codec reset when the video renderer gets disabled. Can be enabled 
 by setting ``MediaCodecRenderer.DEVICE_NEEDS_SKIP_RESET_ON_DISABLED`` to ``true``.

# 4.2.69

---
**Changes**

* SingleControllerPlaylist fixes: stuck when removing the only loaded item, exception when removing 
 the first item if it was the current one, failing to transition to next item when the only loaded
 item plays to the end.
* Added changes to improve clear IPTV zap times to ignore data till a video Keyframe is received
* Updated Exo to avoid IPTV read timeouts at socket close while read is ongoing (for erroneous devices)

# 4.2.68

---
**Changes**

* Added option ``PlayerSDK.FORCE_REOPEN_ON_HDCP_STATE_CHANGE`` to re-open the playback when HDCP state changes.
* Added codec retry mechanism for some crypto exceptions and its overrides 
 ``MediaCodecAudioRenderer.CODEC_RETRY_COUNTER_OVERRIDE`` and ``MediaCodecVideoRenderer.CODEC_RETRY_COUNTER_OVERRIDE``
* Fixed an issue when some transient errors e.g. during license pre-fetch are used instead of fatal ones.
* Fixed a number of issues when the video track is disabled due to HDCP enforcements.
* Added Further checks in CatchupManager and allowed Join Workaround for Playlists on some devices
* Fixed period overlapping issue on DASH streams.

# 4.2.67

---
**Changes**

* Fixed an issue where an AD provided for the future in a VOD stream causes Player state to not 
 transition to Finished state.
* Fixed an issue which prevented some DASH callbacks to be fired when grouped near Period endings
* HLS chunk-less preparation is true by default (Previously the default was false). It is configurable by
``PlayerConfig.allowHlsChunklessPreparation`` (**API Change**) (**Behaviour change**)
* Changed Catchup-Manager to ignore Negative Positions
* Updated Broadpeak's smartlib to version 04.05.01.

# 4.2.66

---
**Changes**

* Fixed a critical issue which provoked the first playback after SDK initialization to take longer
 than expected

# 4.2.65

---
**Changes**

* Improved detection of DRM key expired event under certain conditions
* Events reporting for server side ads (DAI) for mid-roll and post-roll ads are fixed.
* ``PlayerConfig.metadata`` has type ``Bundle`` and not ``JSONObject`` anymore (**API Change**)
* Added background playback with notification linked to its media session in ``mediasession_demo``
* Fixed an issue when some meta data types like ``Bitmap`` are not set to media session
* If there is an ``HttpDataSourceException`` during ads, an error with ``SEVERITY_WARNING`` will
be fired to player listeners and the main video will be played.
* Youbora integration: don't report playhead for live streams
* Added Audio, Video and Subtitle tracks to ``Timeline.Period``
* Fixed a Downloader issue which could prevent selection of text and audio tracks when downloading a
 DASH manifest with Trickplay tracks.
* Fixed an issue which provoked the seek operations originated from a ``CatchupConfiguration`` to 
 always be performed to the live edge of the stream.
* Work around systems with unresponsive CDMs which could make the SDK fail to initialize.

# 4.2.64

---
**Changes**

* DRM license prefetch is supported in multi-period and IMA playbacks with ``PlayerController``.
 ``PlayerSDK.FORCE_DRM_LICENSE_PREFETCH`` option is added to control the behaviour (**Behaviour change**)
* Changed ``onTrackKeyStatusChanged`` to ``onVideoKeyStatusChanged`` providing tracks with changed DRM key statuses (**API Change**)
* Fixed a synchronization issue in ``SingleControllerPlaylist`` and improved cleanup.
* Fixed an issue which sometimes could lead to frozen playback when opening a ``PlayerController``
 with Trickplay enabled in ``SeekMode``.
* Added a new error: ``TYPE_MANIFEST_INVALID``. For now this is only fired whenever there's an illegal
 manifest update in DASH.
* The http response body is exposed in ``CastlabsPlayerException`` if ``PlayerSDK.ENABLE_ERROR_RESPONSE_BODY``
is set to true.
* Fixed lifecycle handling of HLS streams with i-frame tracks.
* Removed Device ID from being reported in the User Agent by default (**Behaviour change**). It can be
 re-enabled through the ``UserAgent`` API if desired.
* Fixed an issue which yielded wrong bandwidth estimations when using the ``COMMON_NBA`` abr algorithm 
 alongside a ``RequestModifier`` which altered the original Request Uri.
* Fixed NPE when DRM provisioning fails with non-DRMToday servers 
* Added ``DrmException`` as a part of the exception stack in non-DRMToday environments (**Behaviour change**)
* Fixed an issue which made the value reported by an InitialPositionProvider to be applied to all playlist items
* Added playback support of protected progressive media sources (**Behaviour change**)
* Downloading and playing offline for i-frame track besides the main video track is supported now (DASH only).

# 4.2.63

---
**Changes**

* Mux: now reporting real pixel resolution for Android TV devices which render a downscaled system UI.
 This might have an effect on the "upscale" Mux metric, as it is now better reflecting that the device
 is capable of displaying a higher quality.
* Mux: Updated to MuxCore 7.7.4
* Fixed an issue when a DRM error is not thrown and video track is disabled instead
* Fixed regression when video is disabled after renewable license update
* The player state issue on phone calls is fixed.
* Fixed an issue which provoked DASH ``availabilityTimeOffset`` to be ignored.
* Fixed regression when enabling ``PlayerSDK.FORCE_HDCP_EXCEPTION`` does not have effect
* Custom HTTP DASH callbacks are supported (Resume, Pause, Rewind and Close). ``CustomDashEventListener``
also provides callbacks to these events.
* Fixed an issue when ``CastlabsPlayerException.TYPE_HDCP_CONNECTION_WARNING`` is not fired 
* Added ``SocketConnectivityCheck`` and set it as a default to monitor device connectivity (**Behaviour change**)

# 4.2.62

---
**Changes**

* OkHttpPlugin: Added API to evict idle connections on demand. Check the OkHttp Plugin section in the
 SDK manual for more information.
* Fixed an issue when selected ``VideoQuality`` may wrongly be reported as null
* New error types are added to the ``CastlabsPlayerException`` for DNS and timeout errors.
* ``SingleControllerPlaylist`` now loads a subset of items dynamically. Learn more by checking the
  ``SingleControllerPlaylist`` section in the manual.
* Fixed an issue with track reselection during playback period change
* Do not selected a video track with all the qualities being disabled
* Improved DRM error handling logics when key is either not valid or HDCP level is not sufficient
* Fixed issue with 2 Network Timeouts thrown when no data source available for IPTV
* Fixed Missing Subtitles Issue with DVB Teletext

# 4.2.61

---
**Changes**

* Fixed an issue when SDK can't be initialized because of OMA plugin on devices with API < 23
* Fixed NPE when creating download of DRM protected stream without offline ID.
* Merged changes to display and present DVB Teletext more accurately
* Created different Timestamp Adjusters for Text tracks in IPTV due to PTS unreliability in those tracks
* Improved parsing of DASH ``ContentProtection`` elements
* Fixed an issue preventing ``MultiControllerPlaylist`` to release controllers when the playlist became empty
* Add ``AdApi`` interface to allow for building custom ad UIs. Check the 'Extensions - Custom ad UI'
 section in the manual.

# 4.2.60

---
**Changes**

* Fix ``InitialPositionProvider`` being invoked more than once for certain types of content.

# 4.2.59

---
**Changes**

* Thumbnail tracks will now start to load whenever the first thumbnail is requested by default.
 This is configurable using a ``LoadingStrategy`` and setting a ``loadStartDelayMs``. Check the 
 `Thumbnails` section in the manual for more info.
* Fixed state transitions issue when using ``SingleControllerPlaylist``

# 4.2.58

---
**Changes**

* Added workaround for device decoders that dont provide accurate keyframe info
* Fixed an issue with ``SingleControllerPlaylist`` which, in some circumstances, caused playback
 to fail while playing a protected multi-period stream

# 4.2.57

---
**Changes**

* Fixed resource leak in thumbnail plugin when ``PlayerController`` is re-used
* Added capability to play IMA Ad tags which contain HLS, Dash and Smooth MediaFiles.
* Player initialization bug is fixed for TextureView mode. (In condition that a stream is 
 played before the previous one receive onVideoSizeChanged event)
* Added release method in ``AnalyticsSession``. This shall be used when detaching an ongoing
 session and not reusing it later.
* SDK documentation fixed to show the correct version.
* Conviva Ad report bugs is fixed.
* Fixed resource leak in Conviva plugin
* Mux plugin can now be configured to report the end of the session when the app is put to background.
* Make ``InitialPositionProvider`` take precedence over the position informed in the configuration

# 4.2.56

---
**Changes**

* Fixed an issue which prevented VTT subtitles with nested tags and multi-line tags from being shown.
* IPTV - UDP/RTP Plugin with Clear Playback Support Added

# 4.2.55

---
**Changes**

* Widevine media Drm properties is configurable now through ``DrmConfiguration``
* Add ``EventStream`` to ``Period``. These EventStreams carry the metadata from the DASH manifest
 element with the same name. This is exposed in the ``Timeline`` Object passed to the
 ``TimelineChangedListener`` and ``InitialPositionProvider`` interfaces.
* Updated Broadpeak's smartlib to version 04.02.03.
* Add APIs to inform Broadpeak Custom Parameters and Options. Check the ``Broadpeak`` section in 
 the SDK manual to learn more.
* Add ``DownloadServiceBinder.autoStopService`` flag. Disabling this flag will prevent the Service
 from automatically stopping once there are no pending Downloads. Note that if this is set you *must*
 make sure to stop it manually through the ``DownloadServiceBinder.stopService()`` API.
* Prevent unnecessary access to MediaRoute service if ``secondaryDisplay`` is set to ``SECONDARY_DISPLAY_ALLOW_ALWAYS``
* Fixed an issue when the audio decoder may fail to initialize when in passthrough mode
* Set source URL in ``CastlabsPlayerException`` and ``DownloadException`` in case of HTTP errors

# 4.2.54

---
**Changes**

* ABR problem for HLS in COMMON_NBA mode is fixed.
* Fixed an issue which prevented ``SingleControllerPlaylist`` to fire ``onItemChange`` when adding
 or removing the current item.
* Added ``SingleControllerPlaylist.playItem(index, periodPosition)`` method to transition to an item 
 at a specific Period position, instead of the default one.
* Fixed fatal error being thrown when failing to resolve a DASH ``UtcTimingElement``.
* Added ``PlayerController.getLicenseRemainingDurationSec`` and ``PlayerController.queryKeyStatus``
 methods to retrieve License information relative to the currently opened DRM session.
* Retry mechanism for device provisioning is implemented.
* Fix an issue for which the ``LiveConfiguration`` was sometimes not being applied in ``SingleControllerPlaylist``.
* Fixed screen size detection not properly working on some Android TV devices.
* Updated Youbora to 6.8.3.

# 4.2.53

---
**Changes**

* Add AdError and AdSkipped to the Conviva Analytics and AdLoader events
* ``PlayerController.setLiveConfiguration`` is accessible from applications now
* Fixed the issue when ``CastlabsPlayerException`` with ``TYPE_DRM_PROVISION_ERROR`` may not be raised
* Youbora subtitle reporting improvements. Now the player will properly report the initial subtitle
 selection on playback start if any preference has been informed. Additionally, `Disabled` will be
 reported whenever no subtitle selection is active.
* Updated Youbora to 6.7.71.

# 4.2.52

---
**Changes**

* Added asynchronous codec operation, see ``PlayerSDK.VIDEO_CODEC_BUFFER_MODE`` and ``PlayerSDK.AUDIO_CODEC_BUFFER_MODE`` (**API Change**) (**Behaviour change**)
* Fixed Mux metadata not being properly informed in some circumstances.
* Updated Conviva to 4.0.23
* Fixed Conviva metadata not properly forwarded to Cast sessions.
* Fixed an issue which in some cases provoked the ``ThumbnailView`` to briefly show an old thumbnail.

# 4.2.51

---
**Changes**

* Updated internal protobuf binaries to javalite 3.20.1. You may need to exclude the ``com.google.protobuf``
  group when using a library that depends on a different protobuf version. Check the `Protocol buffer dependencies`
  section under the manual's `Setup` page (**Important**)
* Improved trick play tracks handling
* Updated Broadpeak's smartlib to version 04.01.01.
* Forward Conviva data to Cast sessions. Added ``customTags`` Bundle parameter when creating 
  Conviva metadata (**API Change**)
* Added Youbora integration app example
* Added audio and subtitle metadata to Youbora analytics
* Extended ``TrackSelectionListener`` and ``FormatChangeListener`` interfaces with new APIs (**API Change**) 
* Updated MUX integration to version 7.0.11. Note that you'll need to add Mux maven repository to your
  gradle's ``repositories`` closure. Check the Mux section entry in the manual for more information.
* Fixed a number of issues related to starting position calculations. Fixed ``LiveConfiguration::snapToSegmentStart``
  not properly being applied in some cases.
* Simplified exposure of ``Timeline`` and ``Period`` updates. New methods in the ``PlayerController`` to
  attach listeners: ``addTimelineChangedListener`` and ``addPeriodChangedListener`` respectively.
* Added ``InitialPositionProvider``. This gives the Application a chance of precisely selecting the
  starting position right after the ``Timeline`` is resolved. You can provide an implementation
  through ``PlayerController``'s ``setInitialPositionProvider`` method.
* Added ``notifyManifestIntervalMs`` parameter to ``LiveConfiguration``. This setting allows to define
  the time interval between internal Timeline representation updates when manifest updates are not 
  required for a live DASH stream.
* The features of the Debug Plugin can now be disabled or enabled after plugin registration.

# 4.2.50

---
**Changes**

* Updated Broadpeak's smartlib to version 04.00.03.
* Added support for targetSdk 31 (Android 12) to the Drm Device Time Checker plugin.
* Fixed ResponseModifier not being called with Response headers for invalid response codes. Added
response code to the provided Response.
* Updated Google Cast SDK to version 21.0.1.
* Forward Vimond data to Cast sessions
* Improved HDCP recovery logics
* Fixed an issue which provoked invalid low bandwidth estimations in some circumstances.

# 4.2.49

---
**Changes**

* Added ``PlayerSDK.ENABLE_TEXT_WITH_NO_PREFERRED_LANGUAGE`` option to control default text track selection. If enabled, the first available text track will be selected when the preferred language is not found.
* Implemented support for cross-player HLS Clearkey requests cache. It is now possible to get the current 
``HlsClearKeyCache`` the SDK is using, and even set which cache to use before playback. Check the 
  Advanced Setup section in the SDK manual for more info.
* Fix an issue which in some circumstances provoked the ABR selection to get stuck.

# 4.2.48

---
**Changes**

* Fixed threading issue on some devices where `MediaCrypto` can not be used cleanly 
  in a multi-threaded context. This will resolve decrypt errors that could be observed 
  on some devices when multiple DRM sessions are used.
* Added support for decoder fallbacks. This feature is enabled by default and permits the SDK
  to fallback to alternative decoders if the primary decoder can not be instantiated. This helps
  resolving decoder initialization problems on some devices especially if multiple players are used.
* Always operate in single session mode when using DRMtoday and Widevine.
* Fixed an issue which provoked side-loaded subtitle tracks to be duplicated when saving 
  ``PlayerController``'s state
* Conviva: Added possibility of detaching a session from a ``PlayerController``. Check the "Session detaching"
 chapter in the Extensions section of the manual.
* Added timeout to wait for HDCP setup completion when starting a playback with digital output protections, see details
 in "Connected HDMI display" section of the manual
* Fixed an issue that occurred when ``SingleControllerPlaylist`` had items with different 
  ``DrmConfiguration`` if they were not ``DrmTodayTodayConfiguration``.
* Fixed an issue which could provoke an error due to restoring offline keys to a wrong session when using ``SingleControllerPlaylist``
* DASH adaptation having 720 rendition is merged with FHD renditions by default, see ``PlayerSDK.MERGE_VIDEO_TRACKS`` and
``DefaultTrackTypeProvider`` for more details (**Behaviour change**)

# 4.2.47

---
**Important Change**

We have identified and fixed an issue introduced in version 4.2.38. Such issue prevents the SDK
to be initialized in time in rare circumstances. Even if the affection rate is low, it is advised 
for all users of the SDK using a version between (and including) 4.2.38 and 4.2.46 to update to the 
latest SDK version.

---
**Changes**

* Added AndroidX Media2 integration, see ``MediaSessionPlugin`` and the manual
section 'Extensions - AndroidX Media2' for more details.
* Mux: it's now possible to set the API key in-between playback sessions. Check the Mux section in 
 the manual for more details.
* Fixed an issue which prevented ABR in HLS streams
* Fixed an issue when error may not be thrown upon audio segment download failure
* Add ``setWrapAroundPlaylistEdges`` method to ``SingleControllerPlaylist``. If enabled, when the
 end of the playlist is reached and ``nextItem`` is called, the playlist will transition to the first item.
* Fixed an issue which may prevent the SDK to be initialized in time (**Important**)

# 4.2.46

---
**Changes**

* Fixed an issue which prevented clear content playback in the presence of a ``DrmConfiguration`` with
 license renewal enabled.
* Fixed an issue which provoked the download notification to disappear upon download completion
* Added a ``HttpListener``. This listener can be set through the ``PlayerController::addHttpListener``
 method, and will inform about HTTP redirects.
* Fixed unnecessary buffer discards in some circumstances when no keys for HD content were present.

# 4.2.45

---
**Changes**

* Improved `PlayerSDK` initialization flow
* Added Missing Ad Preroll Metadata for Mux Plugin and firing separate Ad Break Events for Ads in a Pod
* Added `getOriginalLanguage` to get original (manifest) language tag value for audio and subtitle tracks
* ``BroadpeakPlugin``: added method to programmatically disable the ``BroadpeakPlugin``
* Modified ``DefaultThumbnailView.Callback`` to include Thumbnail timing info. This may ease
 UI building and provide more info for debugging purposes. (**API Change**)
* Added Thumbnail indexing options to request rendering for the 'current', 'next' or 'closest' Thumbnail
 in relation to the requested media time. Check out the "Thumbnail index selection" subsection in 
 the manual's Extensions section
* Improved network retries upon DASH and SmoothStreaming manifest parsing operation
* Youbora integration updated to 6.7.47. Added API to pass in a Youbora ``Plugin`` to the SDK. This
 will allow to link an application Youbora Session with the Video Sessions. Check out the Youbora section
 in the manual for more details.
* Refactored Live Edge Catchup. Improved robustness, added operation flexibility. Check out the "Live Edge Catchup"
subsection in the manual's "Advanced Setup" section
* Automatic DRM Selection will pick Wiseplay only if no other Drm system is available. This only affects Huawei 
 devices with Wiseplay support, in which ``Drm.BestAvailable`` will now return Widevine instead (if present).

# 4.2.44

---
**Changes**

* Fixed an issue where the same video track data is re-downloaded continuously upon license expiration.
The issue was introduced in 4.2.36 and it is recommended to update for all applications where rental licenses are used.
* Fixed firing of start event when Autoplay is disabled for Youbora Plugin

# 4.2.43

---
**Changes**

* Fixed an issue when the main content may start playing first for a few seconds instead of IMA single pre-roll
* Fixed handling of DASH descriptors within `SingleControllePlaylist` context
* Fixed an issue playing content with HDCP restrictions on a non-HDCP display
* Fixed an issue with fetching DRM license for DRM system not being available on a device
* Added changes to pass CustomerViewData to MUX
* Allowing Fatal HDCP exceptions as alternate behavior if required instead of default
* Seek and Re-buffering events now passed to MUX 
* Fixed an issue when TTML extent is not applied to font sizes

# 4.2.42

---
**Changes**

* Fixed DRM sessions for clear content when running on devices with API < 23
* Fixed an issue when downloading content with audio and video tracks having un-aligned durations

# 4.2.41

---
**Changes**

* Added DRM sessions for clear content allowing the player to use the same secure decoders and
avoid decoder re-initializations upon transition from clear to encrypted media part.
Control the behaviour with `PlayerSDK.ENABLE_DRM_PLACEHOLDER_SESSION` flag.
* Fixed an issue with, in some circumstances, prevented a Connectivity Lost Error to be fired more
 than once for a ``PlayerController`` instance.
* Updated MUX integration to version 6.5.0
* Added support for image-based IMSC1 subtitles
* Added Wiseplay DRM support (beta)

# 4.2.40

---
**Changes**

* Added `PlayerConfig.forceInStreamDrmInitData` option to use the DRM data from segments instead of
the manifest. This option needs to be enabled when the key is changed in segments and not in the manifest.
* Added support for ``Clearkey`` keys in `DRMToday`. To make use of this feature, set the ``Drm``
 type to ``Clearkey`` in the ``DrmTodayConfiguration`` object used to open playback.
* Improved playback stability when DRM key is changed in-stream.
* Fix AnalyticsSession setting while using PlayerViewLifecycleDelegate.
* Youbora integration: automatically report the selected Drm.
* Several improvements for Trickplay playback. If using ``PlayerViewLifecycleDelegate``, set its
 ``ResumeConfiguration`` to specify the behaviour of the player when ``resume`` is called. By default
 playback Trickplay mode will be turned off but playback won't be stopped (**Behaviour change**).
 Improved performance and robustness of Seek mode. 

# 4.2.39

---
**Changes**

* Added DRM fallback when `Drm.BestAvailable` type is provided and multiple DRM systems are available on a device.
`DrmConfiguration.drm` and `DrmConfiguration.audioDrm` hold the provided DRM type now and
to get the resolved DRM then `DrmConfiguration.resolvedDrm` and
`DrmConfiguration.resolvedAudioDrm` shall be used (**Behaviour Change**)
* Added optional callback to add custom logic when Audio Focus is lost. Check out the "Audio Focus"
 section ¡n Player Basics in SDK manual for more info.
* Added support for DASH Widevine content protection elements not having PSSH data but only default KID
* Added ``LoadingStrategy`` for smarter thumbnail preloading. Check out the `Thumbnails` section
 on the SDK manual for more information. The default thumbnail preloading has been improved to use
 a ``LoadingStrategy`` which doesn't load thumbnails sequentially anymore (**Behaviour change**).
* Vastly improved parsing times for VTT subtitles. The improvement is more noticeable with larger
 VTT files and slower devices.
* Added DRM `RetryConfiguration` used in license requests. The default is no retries.
* Fixed side-loaded Thumbnails sometimes not properly initialized. Deprecated the use of
 ``ThumbnailDataTrack`` for configuration purposes. Now ``SideloadedTrack`` should be used alongside
 with ``SdkConsts.INTENT_SIDELOADED_TRACKS_ARRAYLIST`` instead. Check the Thumbnails section in the
 SDK manual for more info and examples.

# 4.2.38

---
**Changes**

* Fixed playback with connected secondary display
* Fix support for live DASH-thumbnails by updating the thumbnail index on every manifest update.
* Cast: Forward IMA tag in a compatible manner with PRESTOplay for Browsers V6. Add userID forwarding when
 starting to cast from a PlayerController instance instead of a Bundle.
* Fixed ``PlayerController.getSeekRangeEndUs``, which was wrongly reporting milliseconds instead of
 microseconds. (**Behaviour Change**)
* Fixed an issue when `PlayerControllerPlugin.Component.onOpenState` may not be invoked after the playback
 going back to the foreground. This fixes the issue with Nielsen analytics not being started after going back to
 the foreground.
* Fixed an issue with Period clipping when using DASH streams which transition from dynamic
 to static mid-playback
* Fixed an Audio Focus issue when releasing a PlayerController during trickplay with Seek mode.
* Fixed playback issue with DASH manifest containing CENC descriptor only
* Fixed an issue when `ExternalSourceSelector` may fail to switch to alternative CDN
* Updated Youbora integration to version 6.7.32.
* Fixed an issue while displaying SMPTE-TT image subtitles in live streams with segment-local
  image ids.
* Added handling of DASH multi BaseURLs (**Behaviour Change**)
* Added a callback method in `PlayerSDK` that permits to hook into detection of rooted devices.
* Added `PlayerController.setSSLSocketFactory` to set custom socket factory used in both DRM and
  content HTTPS requests
* Fixed an issue which caused that sometimes subtitles could be rendered off-screen when video
 crop mode was set to "Fit".
 
**CAS Changes**

* Added support for IPTV - RTP Injection.
* Added support for WVCAS.
* Added dual APK Support for AmLogic Platform by adding AmlServiceApplication.
* Added ExoCas Application to test WVCAS functionality.

# 4.2.37

---
**Changes**

* Added track type in the `DownloadException`
* Added ``TrickplayConfiguration.maxSeekFps`` to limit the number of frames displayed while in
 trickplay with Seek mode.
* ``seekWith`` in SingleControllerPlaylist can jump over playlist items now (**Behaviour Change**)
* Multi-key playbacks: updated SDK manual and demos
* Fixed an issue when enabling `PlayerController.setLoopingEnabled` is overridden by the default value in PlayerConfig
* Added ``DownloadServiceBinder.updateDownloadPath(...)`` method to update the internal references
 for Downloads.
* New Downloads with paths in non-scoped locations will be blocked by default (**Behaviour Change**)
 This setting can be overridden by setting ``DownloadServiceBunder.allowNonScopedStorageDownload``
 to ``true``.
* Added support for WebVTT css styles.
* Fixed an issue when opening a manifest without Widevine PSSH box results in no audio and video tracks
* Fixed an issue where playback may raise a fatal exception upon HDMI-connected TV being switched off
* Updated Conviva to 4.0.11.150
* Add support for DRM configuration when using the PrestoPLAY for Web SDK receiver.

**Important Notice regarding downloads**

Due to changes in Android's privacy policies, you may need to migrate your Downloads **before**
updating your app's ``targetSdk`` to 30. For more information check out the "Scoped Storage" section
in manual, under Extensions, Downloader. If you are affected by this, you can go ahead and perform
the migration on your side and update the references in the SDK with the new ``updateDownloadPath``
method. We are also currently working on endowing the Downloader with migration utilities,
which will be published in a future release.

# 4.2.36

---
**Changes**

* Improved playback in Widevine multikey environment with some keys being unavailable.
* Improvements for Trickplay in SeekMode.
* Updated Broadpeak library to version 03.02.01.
* WebVTT: Add support for inline text color styles through the ``<font>`` tag.
* Fix Audio Focus, which stopped working due to a recent update.

# 4.2.35

---
**Changes**

* The option `PlayerSDK.CLIP_PERIODS` is enabled by default now (**Behaviour Change**).
This option is important for DASH multiperiod content having audio and video
component durations unaligned with their period duration.
* Prevent from setting an invalid ``TrickplayConfiguration``.
* Fixed an issue when Conviva plugin may report analytics keys from other analytics providers.
* Fixed an issue when Conviva plugin may not report playback errors
* Conviva demo is part of the SDK bundle now.
* Updated demo application to show how to control the backgrounded playback and playback activity lifecycle
* Integration with Adobe analytics.
* Updated Broadpeak library to version 03.02.00.
* Updated `PlayerController.getLiveStartTime` to use DASH presentation time offsets in case availability
time is not available.
* Fixed an issue which in some circumstances provoked playback to be stuck when enabling
 Trickplay in SeekMode.
* Fixed DASH Thumbnails url calculation when using a ``SegmentTemplate`` with a ``startNumber``
 different than 0.
* Vimond plugin: Fixed exception thrown if ``VimondPlugin`` was registered but not configured.

# 4.2.34

---
**Changes**

* Removed WRITE_EXTERNAL_STORAGE permission from the PlayerSdk manifest. In case an application has a
dependency on `AssetUtils` or `LazyImageLoader` then it will need to add and handle the permission locally.
* Added ``Bundle`` with extra information in ``CastlabsPlayerException``. This Bundle will contain
error-specific keys and values which can provide additional information.
* Mux integration: report extra error data.
* Broadpeak: Updated to library version 03.01.02. Removed one-param constructor and option
 to disable URL redirect (**API Change**). URL redirect is now always delegated to the Broadpeak
 lib, which decides whether to redirect or not based on the provided domain names.
* Fixed an issue when initial video quality with `keepInitialSelection` being enabled is not retained upon period change
* Update IMA SDK to 3.19.4

# 4.2.33

---
**Changes**

* Fixed an issue when content seek may be ignored after IMA midroll is completed
* Fixed an issue when IMA midroll may not start and postroll may not be completed when seeking to the end of a stream
* Fixed Downloader handling of embedded CEA608 tracks.
* `DrmTodayConfiguration` allows setting a `requestId`, instead of always generating a random one.
 Can be set through the `Builder`. This `requestId` can be used to easily locate the request in
 DRMtoday's dashboard.
* Cast: Forward player state (paused or playing) to receiver. If starting cast from a `Bundle` use
 the `SdkConsts.INTENT_START_PLAYING` constant. (**Behaviour change**)
 Properly forward preferred audio and text selections for PRESTOplay Web V6.
* Downloader: Errors have a new error type for DRM errors: `ERROR_TYPE_DRM_ERROR`. In addition, the
 internal DRM error can be queried with the `INTENT_DOWNLOAD_ERROR_DRM` key in MessageHandler.
* Fixed error handling during DRM license acquisition.
* Added looping option to `PlayerConfig`

# 4.2.32

---
**Changes**

* Added `CODEC_NEEDS_SET_OUTPUT_SURFACE_WORKAROUND_OVERRIDE` static configuration option in
 `MediaCodecVideoRenderer`. It can be used to force enabling or disabling Exoplayer's homonymous
 workaround. The value needs to be set before the `open(...)` call.
* Update OkHttp version to 3.12.12.
* Broadpeak plugin. Avoid using Broadpeak redirected URL when it returns an empty URL. Added API
 to disable Broadpeak URL redirect in runtime. Check the Broadpeak section in the SDK manual.
* Fixed an issue when `MultiControllerPlaylist` trick mode playback is stuck after transitioning to the next item
* Fixed `SdkConsts.VIDEO_FILTER_NONE` option not to use display resolution for video filtering
* DebugPlugin. Checking for supported DRMs is now behind a flag. To enable it set `logSupportedDrm`
 to `true`.
* Fixed an issue when DASH adaptations may not be used for playback with merging option enabled
* Fixed retries for Downloads. There was an issue which resulted in the Downloader to retry segment
 downloads more times than defined in the Download's `RetryConfiguration`.

# 4.2.31

---
**Changes**

* Fixed OOM issue on some devices with API < 23 and configured in tunneling mode
* Fixed an issue when frames may not be rendered in trick play mode by tunneling devices with API < 23
* Fixed offline license requests using `DrmConfiguration` not being automatically stored in `KeyStore`.

# 4.2.30

---
**Changes**

* Exoplayer update to 2.11.7
* Improved support of mixed clear-protected items playback in `SingleControllerPlaylist`
* Fixed an issue with background playback on Mi Box 4/S
* Improved playback in tunneling mode
* Fixed an issue when playback may stop playing some audio streams
* Added `Manifest` param to `TimelineListener.onTimelineChanged`. This will be one of Exoplayer's
 internal manifest classes, such as `DashManifest`. (**API Change**)
* Now `RequestModifier`'s headers will be taken into account.
* `ResponseModifier`s will also be called for non-drm Requests.
* Added convenience method to fetch the license for a `Download`: `DownloadServiceBinder.fetchLicense`.
This method takes into account the downloaded tracks and can use the locally stored content to
issue the license request.
* Fix content type MimeType reporting for MUX plugin.

# 4.2.29

---
**Changes**

* Fixed an issue when video may be distorted when changing periods in trickplay mode
* Fixed a leak occurring when releasing the `PlayerController` while in `Trickplay` mode.
* Fixed an issue when transitioning between encrypted with different keys periods may fail
* Preserve `Trickplay` track selection across Period transitions.
* Fixed Track selection in `Trickplay` mode: if a `VideoTrackQuality` is defined as `TrickplayTrack`
in the `TrickplayConfiguration` but it was not marked as such in the DASH manifest, it won't be selected
(**Behaviour Change**)

# 4.2.28

---
**Changes**

* Improved playback stability of mixed clear-encrypted multiperiod content on devices with API >= 23
* Added PSSHv1 support on devices with API < 23 and Fire TV Stick (Gen 2)
* Added DASH callback connection and read timeout settings in `NetworkConfiguration` (**API Change**)
* Fixed an issue when video may be distorted after changing periods
* Improved load control on devices without battery
* Improved seeking trick mode stability in multiperiod content playback

# 4.2.27

---
**Changes**

* Improved playlist transitions with `SingleControllerPlaylist` when playing backwards. The playlist
 will automatically start from the end of the item (**Behaviour Change**).
* Added `SingleControllerPlaylist.previousItem(position)` method, which allows specifying the initial
 position when transitioning to the previous playlist item.
* Improved high frame rate content playback
* Fixed an issue with the MUX integration which could provoke an exception whenever playback failed.
* Added CastlabsPlayerException.TYPE_DRM_PROVISION_ERROR used to raise exceptions during
 device provisioning. DrmLicenseLoader does not raise exception with TYPE_DOWNLOAD_ERROR anymore
 but with TYPE_DRM_KEY_DOWNLOAD_ERROR instead. (**API Change**)

# 4.2.26

---
**Changes**

* Fixed `PlayerController.getVideoQualityMode()` wrongly reporting ADAPTIVE when the selection
 was informed through `AbrConfiguration`'s `initialTrackSelection`.
* Fixed an issue when `PlayerSDK.FORCE_UNSECURED_DECODER` is not applied.
* Fixed an issue when trick play mode does not work correctly on some devices
* Fixed parsing of mp4 atom fields with large unsigned int values
* Fixed visibility of `PlayerView` when type is set to SURFACE_TEXTURE_VIEW
* Added advanced network transfers logging. Can be enabled through `DebugPlugin.logTransferInfo`.
 note that this generates a *huge* amount of logs.
* Fixed seeking backwards trick mode reporting negative position when reaching start of stream
* Fixed an issue which made `enableViewportFilter` to be disabled upon player state save and reopen.
* Added `PlayerModelFilter`, which allows for arbitrary filtering on track selection. Filters can be
 added to the `PlayerController` through the `addPlayerModelFilter` method before the `open()` call.
* Updated Youbora integration to version 6.7.5. Added configuration option to report SDK warnings as
 Youbora non-fatal errors. This has to be enabled on Plugin registration via
 `youboraPlugin.reportWarnings(true)`.

# 4.2.25

---
**Changes**

* Added options to control the speed during and after ads playback (**API Change**) (**Behaviour Change**)
* Added DVB subtitles support for HLS streams
* Fixed an issue when fatal errors are not dispatched to MUX analytics
* Added `VideoFilterConfiguration` to filter video renditions by framerate, bandwidth etc (**API Change**) (**Behaviour Change**)
* Added WV L1 playback restart in `SinglePlaylistController` when HDMI is plugged in/out on some devices
* Subtitles: implemented compensation for overflow. If subtitles are to be rendered outside the
 video area, they will be moved to prevent it.
* Updated the `Youbora` integration to version 6.7.3
* Added `AudioRendererListener` to get information about decoder initialization times and types
 as well as general decoder callbacks and info

# 4.2.24

---
**Changes**

* Added `NotificationHandler` interface to receive intents within `PlayerService` context (**API Change**)
* Added playback control in demos notification bar
* Added auto pause option when HDMI is plugged out with enabled by default (**Behaviour Change**)
* Restart WV L1 playback and suppress exception on some devices when HDMI is plugged in/out
* Replaced `DrmConfigurationProvider` with `ConfigurationProvider` (**API Change**)
* Added applied DRM type to `VideoTrackQuality` and `AudioTrack`
* Fixed an issue that occurred when transitioning from protected to clear content
* Do not throw uncatchable exception when asynchronously closing Widevine or Playready session
* Updated Google Cast SDK to version 18.1.0
* Fixed IMA Ad information not being propagated to Cast receiver
* Added manual IMA Ad scheduling. This feature allows to request ads once playback has already started.
 To enable manual ad scheduling, the `SdkConsts.INTENT_AD_SCHEDULE` Bundle key should be set to `SdkConsts.AD_SCHEDULE_MANUAL`
 Manual ad requests are performed through `PlayerController.getAdInterface().scheduleAd(...)`.
 Check out the IMA section in the Extensions part of the documentation.

# 4.2.23

---
**Changes**

* Fixed leap year issue when OMA license can not be retrieved
* Fixed an issue when CEA608 subtitles may not be displayed

# 4.2.22

---
**Changes**

* Fixed an issue which prevented ad-skipping on Android TV.
* Fixed issue when HLS playback may raise an exception
* Fixed issue when IMA ads may stall and playback do not switch to the main content
* Fixed stability issues in subtitles plugin
* Added configuration field `NetworkConfiguration.drmAcquisitionTimeoutMs`, which defines the maximum
 total time a single DRM request can take. If this threshold is reached, a fatal exception is thrown.
 This setting is disabled by default (no timeout).
* Fixed issue when seeking of multi-period or IMA streams may fail
* Fixed an issue with MUX which provoked network retries to cause an Exception.
* Improved robustness of PlayerController's open and release

# 4.2.21

---
**Changes**

* Fixed issue when IMA's ads completed event may not be fired
* Fixed issue with bandwidth estimation which provoked the player to select unintended video qualities.
* Fixed an issue that provoked certain CDM implementations not to work with license renewal.

# 4.2.20

---
**Changes**

* Fixed an issue when setting the volume of the `PlayerController` before it was prepared.
* MUX Data integration: allow to inform a `CustomerPlayerData` upon plugin configuration. Added
`mux_demo` sample application showcasing a sample implementation.

# 4.2.19

---
**Changes**

 * Fixed an issue that could make the Player to throw a fatal Exception while playing some items in
 a `SingleControllerPlaylist`.
 * Added integration with Nielsen Analytics
 * The INTENT_SIDELOADED_TRACKS_ARRAYLIST is used also when downloading the content
 * Added option `DrmTodayConfiguration.Builder.renewalThreshold` to enable automatic key renewal
 * Added IMA DAI integration (**API Change**)
 * Integrated with AudioManager (**Behaviour Change**). Now playback start and resume operations
 will acquire audio focus, pausing any other apps that also comply to the API. At the same time, the
 player will automatically pause if another app requests audio focus. To keep the old behaviour
 set the `audioAttributes` in the `PlayerConfig` or the `SdkConsts.INTENT_AUDIO_ATTRIBUTES` key
 in the `Bundle` used to start playback to `SdkConsts.AUDIO_ATTRIBUTES_FOCUS_DISABLED`.
 * Added MUX Data integration. See <http://mux.com/>.
 * Fixed track switching between tracks that have DRM init data informed in the manifest and in PSSH boxes
 * Improved Widevine support detection for some devices which report it as unsupported
 * Fixed a bug that caused a thread leak when using Trickplay in Seek mode
 * Fixed usage of `TrickplayConfiguration.maxTrackBitrate` when set to 0 or Integer.MAX_VALUE

# 4.2.18

---
**Changes**

 * Added `onFatalErrorOccurred` callback to `PlayerListener`. This method will be invoked on fatal
 errors, **before** the `PlayerController` is released.
 * Implemented multithreaded-rendering. Now playback on older devices or the ones with a slower
 codec will show smoother playback with less dropped frames.

# 4.2.17

---
**Changes**

 * Fixed an issue that provoked unnecessary DRM license requests on quality changes for DASH streams
 with more than one ContentProtection entry per AdaptationSet.
 * Added support for Thumbnails on live DASH streams.
 * Fixed an issue when download progress of a single MP4 file is not sent.
 * Updated Broadpeak integration to version 02.06.04.2416
 * Fixed download and playback of DASH manifests with no filename and chunks with equal names, only
 differentiated by their query params.

# 4.2.16

---
**Important Change**

This release starts using AndroidX support libraries and therefore the dependant applications have to be
migrated to AndroidX as well, see details `Android Migrating to AndroidX` in android developer portal.

---
**Changes**

 * Par and sar ratios from DASH manifest are now set to `VideoTrackQuality`
 * Fixed an issue when `SingleControllerPlaylist` playback may raise an exception
 * Fixed an issue when during `SingleControllerPlaylist` playback seeking may cause temporary screen blackout
 * Updated to Exo v2.10.4

# 4.2.15

---
**Changes**

 * Use default locale during text formatting  when the requested locale raises an exception
 * Updated documentation with `Expired Keys and System Time Changes` and demos example
 * Fixed an issue when deleting a download may cause another download to transition into paused or error state
 * Fixed cast sample app to unescape received custom message

# 4.2.14

---
**Changes**

 * Fixed false detection of secondary screen on some older devices
 * Fixed exposed Period start and end times for live DASH and Smooth streams.
 * Fixed an issue when transitioning between protected streams in playlists while using Trickplay
 mode on pre-M devices.
 * Parse Dolby audio tracks "chanmap" field as defined in the ETSI TS 102 366 standard.
 * Fixed an issue when the playback may stuck in buffering state after DASH manifest being transitioned
  from dynamic to static type

# 4.2.13

---
**Changes**

 * Fixed an issue when the ABR algorithm may keep staying on the initial bandwidth
 * Fixed an issue preventing margins to be applied to TTML Regions (Spans).
 * Added `override` param to `SubtitlesStyle.Builder.regionColor` (**API Change**)
 * Fixed an issue which prevented the start position to be applied for live streams
 * Fixed an issue when playback may fail when applying initial position offset

# 4.2.12

---
**Changes**

 * Fixed an issue which prevented margins to be applied to image subtitles if font size was specified
 * Added MP4 webVTT subtitles support (subtitles_plugin)
 * Fixed issue when CEA608 subtitles may be incorrectly decoded (subtitles_plugin)
 * Fixed fatal exception when parsing an invalid `traf` MP4 box containing no `trun`
 * Whenever a fatal error occurs, the `onError` callbacks will be called **after** the `PlayerController`
  is released (**Behaviour Change**)
 * Fixed issue when trick mode may reset the current playback position
 * Added `TrickplayConfiguration` flag whether to keep DASH event callback enabled during trick mode

# 4.2.11

---
**Changes**

 * Use a dedicated Executor to release sessions on MediaDrm and thus preventing other background
  tasks from stalling in case the CDM takes too long to close.
 * Fixed issue when `onItemChange` is called after adding an item in `SingleControllerPlaylist`
 * Added DRM connect and read timeouts in `NetworkConfiguration`
 * Fixed issue when playback of the playlist with identical configs is stopped
 * Fixed issue when trick mode configuration may not be applied in `MultiControllerPlaylist`
 * Added duration and playback position reporting of period-based ads

# 4.2.10

---
**Changes**

 * Fixed issue when audio and text track selection may not work under certain conditions
 * Fixed issue when applying trick play mode before the stream is opened may not have any effect
 * Fixed setting DASH video adaptation set ids to `VideoTrack.id` and added `VideoTrackQuality.id`
 * Updated to Exo v2.9.6
 * Fixed issue when prefetching WV license on devices < M in `SingleControllerPlaylist`
 * Fixed an issue with Trickplay in Seek mode which provoked a low frame rate on some devices

# 4.2.9

---
**Changes**

 * `DefaultThumbnailView` will now always render Thumbnail borders, not only on small screen devices (**Behaviour Change**).
  A new method has been added to customise the border color, `DefaultThumbnailView.setBorderColor(Paint)`.
 * Added DASH event callbacks handler
 * Added timeline and period changed events
 * Added support of period-based ads via `PlayerController.setPeriodInfoProvider`
 * Fixed issue when playback may stall during rewinding the playlist and item transition

# 4.2.8

---
**Changes**


 * Forcing Widevine Level 3 playback can be done on a per-session basis through the
   `DrmConfiguration.forceWidevineL3` field, instead of through a global variable. This allows for
   finer control in cases where multiple player instances are used.
 * Fixed Audio Capabilities for Sony Bravia devices
 * Fixed issue when offline Widevine license may be incorrectly interpreted as expired on some devices
 * Fixed an issue which prevented proper item transition while using `SingleControllerPlaylist`
   in Trickplay-Seek mode
 * Fixed issue when cancelling download may cause the downloader not being able to resume
 * Keep codec instance when seeking into a new Period if possible
 * Fixed storage low threshold calculation
 * Fixed the downloader progress and its overall stability under poor network conditions

# 4.2.7

---
**Changes**

 * Fixed Text and Audio tracks selection preservation across multi-Period content when they have
  a different number of AdaptationSets.
 * Fixed issue where Audio Segments were still downloaded in SEEK Trickplay mode.
 * Fixed issue with manual video track selection where the player was not moving forward.

# 4.2.6

---
**Changes**

 * Updated to Exo v2.9.4
 * Fixed an issue related to DRM session handling while using `SingleControllerPlaylist`.
 * Start position configuration option is now taken into account for all items in
 `SingleControllerPlaylist`.
 * Fixed issue on some FireTV devices where DRM key properties can not be queried.
   The underlying CDM does not permit to query the properties and we catch the error
   now so that playback can still continue.
 * Fixed issue with OkHttp Plugin where separate request and segment timeouts were
   not applied correctly.
 * Added method in GoogleCastManager to retrieve the currently applied `SubtitlesStyle`, and
   Intent param `GoogleCastManager.INTENT_SUBTITLES_STYLE` to inform them upon cast start.
 * Renamed `AbrConfiguration.METHOD_NBA` to `AbrConfiguration.METHOD_EXO` (**API Change**)

# 4.2.5

---
**Changes**

 * `BufferConfiguration` can now be modified mid-playback. Changes take now effect immediately.
 * Improved integration with Nielsen analytics (**Behaviour Change**)
 * Updated to Exo v2.9.2
 * Implemented `SingleControllerPlaylist`. This is a Playlist implementation which uses one underlying
 `PlayerController` in order to achieve seamless transition. Note that this approach is incompatible
 with side-loaded Advertisements and only Widevine DRM is supported.
 * Deprecated `PlaylistController` in favour of `MultiControllerPlaylist`.

---
**Known Issues**

 * There's a known issue when using `SingleControllerPlaylist` in conjunction with Audio Tracks
 which don't span the entire media duration. To workaround this issue, you can enable the setting
 `useStandaloneMediaClock`.

# 4.2.4

---
**Important Change**

This release adds support for 64bit native code to all plugins including the OMA plugin. It also
updates the OMA plugin so permit targeting Android API >= 23 with. That means you no longer
need to split APKs when you are using OMA and you also no need to filter for an
64bit native libraries.

---
**Changes**

 * Added `VideoRendererListener` to get information about decoder initialization times and types
   as well as general decoder callbacks and dropped frame information
 * Improved `PlayerController` stability in multi-threaded context
 * Fixed an issue preventing `TrickplayConfiguration` to be applied on playback start.
 * Added `Intent` param to enable Trickplay mode; `SdkConsts.INTENT_TRICKPLAY_ENABLED`. Available also
 in the `PlayerConfig` as `enableTrickplayMode`.
 * Better integration between `TrickplayConfiguration` and playlists. Now there's a flag to automatically
  carry over the current `TrickplayConfiguration` onto the next `PlayerController`. See
 `Playlistcontroller.KEEP_TRICKPLAY_CONFIG`.
 * Added option to preserve the `Surface` of the `PlayerView` for multiple playbacks. This provides
   potentially better performance when new content is loaded as the surface does not need to be
   re-created and allows to keep the last frame on screen while the decoder is disposed. This
   feature can be enabled with `SdkConsts.INTENT_PRESERVE_PLAYER_VIEW_SURFACE` or via
   `PlayerConfig.preservePlayerViewSurface`.
   If you want to preserve the surface but still render a black screen when the decoder is
   disposed, you can use `SdkConsts.INTENT_PUSH_BLACK_SCREEN_ON_DISPOSE` or
   `PlayerConfig.pushBlackScreenOnDispose` to let the decoder push a black frame when disposed.
   Please note that pushing black frames is only supported on API >= 19.
 * Added 64bit native binaries. **Note** that this might have implications
   on your build and you might be able to remove any ABI filters (**Build Change**)
 * Add support for target API >= 23 for the OMA Plugin
 * Fixed an issue which provoked some built-in device screens to be detected as secondary screens
 and thus prevented playback when the `PlayerSDK.SECONDARY_DISPLAY` flag was set to
 `SdkConsts.SECONDARY_DISPLAY_NEVER`.
 * Fixed an isue with Broadpeak Plugin which prevented from performing content redirection
 for sessions other than the first one.
 * Fixed issue where Manifest load retries were not reported correctly
 * Fixed issue with stale CDN switches
 * Added new `CastlabsPlayerException.TYPE_MANIFEST_PARSING_FAILED` error type to identify
   manifest parsing errors and loaded but invalid manifests
 * Fix playback position not reported when seeking while paused.
 * Fix modifying fields of the `TrickplayConfiguration`, such as `preferTrickPlayTracks`, not taking
 effect if modified while in playback.
 * Moved `PlaylistController` to the `com.castlabs.android.player.playlist` package, please
 change your import statements (**API Change**).
 * Implemented `PlayerController` pooling, allowing to re-use them and allowing for more advanced
 features in the `PlaylistController`.
 * New `PlaylistController.Builder`, which should be used to create an instance of `PlaylistController`
 (**API Change**).
 * `PlaylistController` supports now background playback. This is intended to use for a "live channel"
 use case. Keep in mind this feature will consume high amounts of bandwidth and requires more than
 one decoder on the device. Have a look at the `backPlayers` and `forwardPlayers` settings in the
 `PlaylistController.Builder` to enable this feature.
 * Added flag to move the current `TrickplayConfiguration` from one item to the next one:
 `PlaylistController.KEEP_TRICKPLAY_CONFIG`.
 * Playback will jump to the previous item (in playlist order) when playback position reaches 0
 and playing at a negative speed (**Behaviour Change**). Note that if you want to force a specific
 playback position when this happens, you'll still need to add a `PlaylistListener` listener and
  implement your logic in the `onItemChange` method.

# 4.2.3
 * Added Dash CDN switching mechanism (**API Change**) (**Behaviour Change**)
 * Added the ability to controll the DASH manifest update duration in the `LiveConfiguration`
 * Allow to overwrite manifest update period for DASH live streams
 * Allow to specify a time sync safety factor for live streams
 * Fixed issue with segment number calculation for large segment numbers
 * Adjusted low latency profile to contain custom retry behaviour
 * Added `TrickplayConfiguration`, which allows more fine-grained customisation for Trickplay
   playback. Check the Advanced Setup in the SDK manual.
 * Added Download Error to the `StreamingEventLister#onLoadError` callback (**API Change**)

# 4.2.2
 * Fixed the use-case when the `FormatChangeListener` may not be called
 * Added param in `PlaylistController.open` to specify at which playlist item to start playback.
 * Fixed thumbnail loading issues when using `PlayerConfig`.
 * Fixed ad view not added to PlayerView when attaching one to a PlayerController asynchronously.
 * Fixed PlayerViewController buttons availability and focusability depending on available tracks.
 * Fixed an issue when directly destroying a PlayerController attached to a PlayerView.
 * Added `PlaylistListener.onPlaylistEndReached` which will be notified on Playlist completion. (**API Change**)
 * Added `PlaylistController.AbstractPlaylistListener` as a convenience default implementation for the
 `PlaylistController.PlaylistListener` interface.
 * Apply subtitle margins also for image-based subtitles.
 * All `PlayerViewPlugin`s depend now on the `PlayerView`, and all the View-providing plugins can now work
 without the corresponding `PlayerViewPlugin`. This way you can use any plugin such as `SubtitlesPlugin` or
 `ThumbsPlugin` without a `PlayerView`.
 * Deprecated `SubtitleViewWrapper`. Create a `SubtitlesView` either programmatically or by defining it
 in a layout, and set it to the `PlayerController` through its `setComponentView()` method.
 * Fixed issue with live edge delay on some streams
 * Added "Advanced Setup" chapter to our manual. Here we explain how to tweak live and low latency-
 related settings.
 * Added `PlaylistController.setItemChangeFlags()` method. This allows to configure the behaviour
 when changing playlist items. You can dictate whether to keep selected tracks and quality or not, and
 to carry over the last bandwidth estimate to the new `PlayerController`.
 * Added option to read screen dimensions using the legacy approach. This is found to workaround some
 device resolution detection issues in some STBs. To enable this for a device, use the static method
 `PlayerSDK.addLegacyDeviceScreenResolution("Manufacturer", "Model")` in your SDK setup code.

# 4.2.1
 * Added `PlayerConfig` object as an option to start playback, which deprecates `PlaybackState` (**API Change**).
 * Added Kotlin extensions for Player configuration. Have a look at the new ``Kotlin`` section in the SDK manual.
 * Added `PlayerSDK.ENABLE_TRICK_MODE_TRACK_SWITCH` option to use DASH trick mode tracks (**API Change**) (**Behaviour Change**)
 * Added `onFullyBuffered` method to `PlayerListener` interface. (**API Change**)
 * Added playlist support through the `PlaylistController`.
 * Fixed Surface management issues when re-using a `PlayerView` across different `PlayerControllers`.
 * Added `INTENT_CLIPPING_START` and `INTENT_CLIPPING_END` in order to clip the start and/or end times.
 * Added `Track.LABEL_LOCALE` to customize in which Locale the Subtitles and Audio track Locale labels are displayed.
   Defaults to current system Locale.
 * Fixed an issue which made the same SubtitleView to be re-used across multiple PlayerControllers.
 * `LiveConfiguration.liveEdgeLatencyMs` now also affects HLS streams. If informed, the HLS-specific
   `LiveConfiguration.hlsLiveTailSegmentIndex` param will be ignored. (**Behaviour Change**)
 * Avoid unnecessary codec reconfiguration on video quality change

# 4.2.0
 * Updated Exo to r2.8.0
 * Added `DrmDeviceTimeCheckerPlugin`. This plugin will perform periodic checks related to DRM licensing.
   It workarounds a Widevine limitation by performing time-related checks while playing protected content.
 * Set `AbrConfiguration` minimal duration of the buffer to retain after discarding the segments (**API Change**)
 * Added `PlayerSDK.SSL_KEY_STORE` to add custom SSL key store as secondary to the system default one (**API Change**)
 * Updated IMA to 3.8.5, improved performance and refactored IMA plugin and ads interfaces (**API Change**) (**Behaviour Change**)
 * Added `setMaxVideoSizeFilter` method in `PlayerController` which allows to change the maximum
   resolution for the ABR algorithm while in playback.
 * Added `DrmLicenseLoader.remove` in order to remove locally stored DRM licenses. Currently only available
   for Widevine.
 * Fixed offline license fetching on un provisioned devices.
 * Improved support for Ultra Low Latency streams. Added `getLiveEdgeUs`, `getPositionInPeriod` and
   `setPositionInPeriod` methods in `PlayerController`. Catchup behaviour improved.
 * Added debugging charts. These are found in the "debug_plugin". `PlayerStateChart` shows the player
   state history and `PlayerMetricChart` can show various player metrics. You can enable a default overlay
   with the `DebugPlugin`'s `debugOverlay` method. You can also create your own `Metric`s to be drawn
   by the `PlayerMetricChart`.
 * Moved `onVideoFormatChange` and `onAudioFormatChange` methods out of `StreamingEventListener` into new
   `FormatChangeListener` interface. (**API Change**)
 * Added castLabs `Log` class. It allows to set the log level in order to hide certain log mesages,
   and to register `Loggers` that will receive all castlabs logs messages - regardless of the log level.
 * Added `getBackBufferTime()` method to `PlayerController`. This returns the oldest position
   that still has buffered content. A seek operation to a position >= getBackBufferTime should
   be quick since the media is still present in the buffer, and won't trigger content re-download.
   This is configurable through the `BufferConfiguration`.
 * Content load retry errors won't be fired as a Warning exception anymore. (**Behaviour Change**)
 * Content load retry attempts can be retrieved with via the `StreamingEventListener`. (**API Change**)
 * Fixed PNG subtitles not showing when defining `backgroundImage` and `duration` in different xml tags.
 * Added Request and Response Modifiers for DRM license and provisioning requests to implement custom DRM backends
 * Common ABR algorithm can now be selected in the `AbrConfiguration` (**Behaviour Change**)
 * Add documentation about Drm key removal.
 * Added `Downloader` network configurations (retry options) (**Behaviour Change**) (**API Change**)
 * Updated Youbora library to version 6.1.9. Fixed seek and autoplay related issues.
   Added global config variable to disable offline sessions `YouboraPlugin.ENABLE_OFFLINE_ANALYTICS`.
 * Added `SubtitlesPlugin.SubtitlesPluginComponent` in order to get the `SubtitlesView` when not using
   a `PlayerView`. Added optional `SubtitleViewWrapper` custom view to take care of listening for
   the `SubtitlesView` to be ready.

# 4.1.11
 * Added `drainWhileCharging` property to `BufferConfiguration`. If this flag is enabled will prevent
   the buffer from draining if the device is charging. Enabled by default (**Behaviour Change**).
 * Added CEA608 support in CL subtitles plugin (**API Change**)
 * Updated NDK to r16b

# 4.1.10
 * Added support for live CMAF low latency.
 * Added `LowLatencyProfile` to easily set params for a low latency scenario.
 * Deprecated `INTENT_LIVE_EDGE_LATENCY_MS` intent parameter. Use the `LiveConfiguration` object instead.
 * Added option to force a custom UTCTimingElement for DASH streams.
 * Updated Youbora integration to 6.1.5 (**API Change**)
 * Added `PlayerSDK.DUMMY_SURFACE_MODE` to force disable dummy surface on some devices.
   This can be together with the IMA plugin to prevent issues where the decoder can not be initialized
   properly.

# 4.1.9
 * Downloader: persist the internal metadata every `DownloaderPlugin.DEFAULT_METADATA_PERSIST_INTERVAL_MS` (**API Change**)
 * Fixed issue where player State could go through Idle between Preparing and Buffering

# 4.1.8
 * Refactored `PlayerPlugin interface` (**API Change**)
 * Added font size preset in pixels in the `SubtitlesStyle` (**API Change**)
 * Fixed issue around ABR video switching
 * Fixed issue when the ABR may not be triggered after switching from manual video selection

# 4.1.7
 * Updated to ExoPlayer r2.6.1
 * Added option to prioritize time over size thresholds in the `BufferConfiguration` (**API Change**)
 * Google cast: added INTENT_STREAM_LIVE and INTENT_STREAM_DURATION keys to inform the receiver
   about stream type and stream duration respectively.
 * Fixed an issue that could sometimes expose a wrong current video quality.

# 4.1.6
 * Fixed issue related to player state saving
 * Added Downloader plugin parameter to set downloader threads priority
 * Fixed issue when the incorrect downloader progress may be sent
 * Fixed an issue when the downloader may re-download the completed chunk in case of errors
 * Added subtitle image scaling modes in SubtitlesStyle; Fill (default), ScaleWidthBottom, ScaleWidthTop, Fit
 * Added Google Cardboard support for 360 video playback

# 4.1.5
 * Updated to ExoPlayer r2.6.0
 * Improved the selection of the default video track when multiple are present (**Behaviour Change**)
 * Updated Conviva core to 2.133.0.34793
 * Added option to change video tracks filtering by resolution, see `INTENT_VIDEO_SIZE_FILTER` (**API Change**)
 * Added possibility to change the IMA language settings via `ImaPlugin' (**API Change**)
 * Ensure that download progress events are not triggered for a canceled download
 * Improved storage low detection in Downloader Plugin
 * Added new storage-low mode to downloader plugin to keep downloads queued.
   This allows you to either pause downloads (current behaviour and default) or keep
   downloads queued when running out of disk space.
   Please see the API documentation for the `DownloaderPlugin` for more details.
 * Allow to specify a custom storage threshold for the Downloader Plugin.
   Please see the API documentation for the `DownloaderPlugin` for more details.
 * Added better error handling for the Downloader Plugin.
   * Error type is now reported
   * HTTP Status code is reported if available
   * HTTP URL is reported if available
   * Please see the API Docs for `MessageHandler` in the Downloader Plugin for more details
 * Extended and improved Downloader Demo Application

# 4.1.4
 * Forward Widevine and Playready DRM configurations to Cast receiver.
 * New `CastInfoProvider` interface in `GoogleCastManager` that allows intercepting and modifying Cast requests.
 * Fixed some Downloader related issues.

# 4.1.3
 * Fixed issue with key rotation and session sharing on some older devices
 * Fixed issue with custom headers for downloaded content
 * Fixed issue with query parameters for downloaded content where the baseURL was not used correctly

# 4.1.2
 * Added possibility to set subtitles drawing margins in `SubtitlesStyle` and `SubtitlesViewComponent` (**API Change**)
 * Added generic `RequestModifiers` that can be added to a `PlayerController`
   (see "Player Controller/Additional Query Parameters" for an example).
 * Deprecated `INTENT_INITIAL_VIDEO_QUALITY` and `INTENT_INITIAL_VIDEO_QUALITY_KEEP` intent parameters.
   Use the new `INTENT_ABR_CONFIGURATION` instead.
 * Extra headers and query params informed in the Bundle passed to `prepareDownload` with
  `INTENT_HEADER_PARAMS_BUNDLE` and `INTENT_QUERY_PARAMS_BUNDLE` constants are now applied
   when fetching the manifest and files of the resulting `Download`.
 * Deprecated `DownloadServiceBinder`'s `getDataSourceFactory`. Use the `INTENT_HEADER_PARAMS_BUNDLE` and
   `INTENT_QUERY_PARAMS_BUNDLE` keys to inform about extra download params in the Bundle passed to
   `prepareDownload` instead.

# 4.1.1
 * Fixed an issue preventing the Downloader to be promoted to foreground in pre-O devices.
 * Side-loaded text tracks are now downloadable through the Downloader plugin.
 * Improve speed of `PlayerController.release()` and made DRM session releases async

# 4.1.0
 * Fixed an issue when the DASH metadata may not be extracted.
 * Fixed an issue when subtitles may not be displayed.
 * Added `CastlabsPlayerException` types `TYPE_AUDIO_UNSUPPORTED`, `TYPE_VIDEO_UNSUPPORTED` and `TYPE_TEXT_UNSUPPORTED`.
 * Added option to merge DASH video adaptations based on Representation types (e.g. SD, HD, UHD)
   The option can be enabled and disabled with the global parameter `PlayerSdk.MERGE_VIDEO_TRACKS` or per play session with the
   `SdkConsts.INTENT_MERGE_VIDEO_TRACKS`. By default the option is enabled. (**Behaviour Change**) (**API Change**)
 * Added codec weights to select default video track (previously was the very first video track in the manifest) (**Behaviour Change**)
 * Fixed issue with Audio-Track selection on downloaded MP4 content
 * Added Downloader compatibility for Android Oreo (**API Change**) and a persistent notification must be shown when a download is ongoing (**Behaviour Change**).
 * Fixed and issue with stream duration not being reported correctly for some segmented DASH manifests
 * Updated `BufferConfiguration` and added a dedicated builder
 * Added dedicated `AbrConfiguration` (see example in Demo App) to fine tune ABR (**API Change**)
 * Moved initial video track selection to `AbrManager` (**API Change**)

# 4.0.7
 * Improved the DrmUtils synchronization (**API Change**)
 * Defer the analytics session creation on asset replay. (**Behaviour Change**)
 * Fixed `PlayerController.isPlaying()` when the asset finished playing (**Behaviour Change**)
 * PlayerUI plugin: enabled replay when the asset finished playing.
 * Add support for generic (SCTE-35, emsg, ID-3) inband meta-data (**API Change**)

# 4.0.6
 * Fixed issue with DRM init data validation when no Widevine header data are present
 * Made `DrmUtils` threadsafe

# 4.0.5
 * Updated to Exo v2.5.2
 * Added `PlayerSDK.ENABLE_MAX_REF_FRAME_WORKAROUND` (off by default) to workaround
   issues on some devices with specific content.
 * Fixed issue with WebVTT rendering regression from 4.0.4
 * Fixed DRM related issue on API 18

# 4.0.4
 * Added `SdkConsts.INTENT_ANALYTICS_SESSION_TYPE` specifying when to create analytics session.
 * Fixed issues when the ads playback or main playback may stay paused after midroll ad.
 * Fixed an issue when the main playback may fail after ads playback.
 * Fixed an issue when the player initial offset (seek) is reported to analytics session.
 * Downloader: fixed an issue when byte-order-marks are not correctly handled.
 * Updated to Exo v2.5.1
 * Fixed CL Exo library versioning
 * Added `PlayerController.isLive` to check whether the stream is live or not (**API Change**)
   `PlayerController.getDuration` for live streams returns the duration of the region of media
   currently available for the playback (since v4.0.0) (**Behaviour Change**)
 * Fixed issue with KeyID extraction in DRMtoday-Mobile environments
 * Support for Thumbnail extraction from DASH manifests.
 * Added `PlayerController.getThumbnailTracks` to get a list of currently registered Thumbnail tracks,
   both side-loaded and manifest-loaded (DASH). (**API Change**) `ThumbnailData` class becomes
   `ThumbnailDataTrack` and its fields are now accessible through getters and setters.
 * Added support for SMPTE-TT images

# 4.0.3
 * Fixed issue when video may not be played due to incomplete codec capabilities reported by a device (**Behaviour Change**)
   Added options `PlayerSDK.VIDEO_CODEC_FILTER` and `SdkConsts.INTENT_VIDEO_CODEC_FILTER` to specify the video filtering policy. (**API Change**)
 * Fixed compatibility issue with Android O Preview
 * Added configurable Http timeout for OMA-DRM requests
 * Fixed decoder selector on platforms where multiple codecs for the same mimetype are available. (**Behaviour Change**)
 * Fixed downloader automatically pausing all downloads when device runs into low storage
 * Added GoogleCastManager helper to ease Cast implementation
 * Expose Conviva underlying Client API to allow advanced usage
 * Fixed NPE when selecting non-existing tracks for downloader

# 4.0.2
 * Added DRM error type TYPE_DRM_EXCEPTION used when exception occurs during communication with DRM server
   (not DRMToday server) (**API Change**)
 * The PlayerListener's onPlayerModelChanged() event is added to notify about available and
   selected tracks. Note that this information is not available in PlayerController's Preparing
   state anymore (since v4.0.0) (**Behaviour Change**) (**API Change**)
 * Fixed setting the playback speed for the streams without audio tracks.
 * Added support for multiple and changing DRM keys when doing multi-period playback
 * Added listener interface to `PlayerControllerView` to expose events such as visibility changes
 * Added `SubtitleViewComponent` implementations as components of the `PlayerView`.
   This allows access to the underlying Subtitle Views, independent of the plugin used for
   subtitles. Please check the extended Demo App and the API documentation of
   `com.castlabs.android.views.SubtitleViewComponent` for details how to access the view.

# 4.0.1
 * `PlayerController`'s `getPosition` for live streams reports the position within the media region
   available for the playback (previously in v3 was the position based on stream's Epoch time) (**Behaviour Change**)
   If needed the API `getLiveStartTime` can be used to get the Epoch based start time of the available
   media region.
 * Fixed setting live edge latency value for live streams.
   The default value is the one from manifest if specified (**Behaviour Change**)
 * Downloader: fixed issue when the download may not be resumed after the load error
 * Downloader: added filtering of video tracks by default display resolution
 * Added auto-detection of `.webm` streams
 * Fixed IMA stream open error handling
 * Added onDurationChanged callback in PlayerListener. (**API Change**)
 * Updated conviva integration to the Conviva v2.125.0.33492
 * Update Crashlytics plugin dependency to 2.6.8
 * UserAgent will not contain any non-ASCII characters by default. (**Behaviour Change**)
   You can disable the filter by setting `UserAgent.STRIP_NON_ASCII_CHARACTERS = false`.
 * Deprecated the `INTENT_PREFERRED_LANGUAGE` language parameter and
   introduced `INTENT_PREFERRED_AUDIO_LANGUAGE` and `INTENT_PREFERRED_TEXT_LANGUAGE` to
   explicitly set the preferred audio and text languages
 * Updated `PlaybackState` constructors to take preferred audio and text language separately (**API Change**)
 * Updated OkHttp-Plugin to use OkHttp 3.8.1
 * Added Beta Version of the Conviva-Plugin

# 4.0.0

 * Fixed a number of issues when the downloader is restarted
 * Added v3 downloader backward compatibility
 * Fixed issue when subtitles may not be displayed by the CL subtitles plugin
 * Switched to Exo Player 2.4.2
 * Added support for tunneling on API >= 21 using
   `SdkConsts.INTENT_TUNNELING_ENABLED` bundle parameter.
 * Added `regionColor` to subtitle syles to overwrite the TTML region color

# 4.0.0-rc1

 * Switched to Exo Player 2.4.0
 * Added support for thumbnails
 * Added initial version of the Player UI plugin
 * **API Changes** and cleanup
 * Removed deprecated classes and activities
 * Removed unused resources
 * Prefixed all castlabs resources

# 3.4.3

 * Fixed issue with subtitle downloads from absolute URLs
 * Fixed issue with `PlayerView` layout properties being passed to an internal view
 * Fixed issue when downloading audio-only content
 * Fixed issue where Error state was not delegated correctly when download errors occurred

# 3.4.2

 * Fixed Issue with empty variant and asset ids
 * Added support for parallel downloads in the downloader plugin
 * Renamed `getTotalSize` to `getEstimatedSize` in downloader plugin (**API Change**)
 * Estimate download sizes based on bitrate or range request length
 * Performance improvements on the Download storage
 * Report Download Progress as `ACTION_DOWNLOAD_PROGRESS` through the broadcast manager

# 3.4.1

 * Fix Issue where Widevine L3 Fallback can not be applied on some devices
 * Fix issue with live streams and temporary redirects that should be persisted

# 3.4.0

This is the first release that contains the OMA plugin as a single
build for both production and development environments. You
**need to update you build setup** to adopt the single library. This
practically means that you can remove the "-Development" and
"-Production" extensions from the version name.

**Note** that the default for offline licenses also *changed*. If
you want to use OMA offline licenses, you need to configure
the `DrmTodayConfiguration` with offline support the same way
you would for Widevine DRM.

 * Single OMA Library (**Build Environment Change**)
 * Support for multiple OMA environments in one library
 * Support for custom Activation servers with OMA DRM (DRMtoday Onboard)

# 3.3.4

 * Fixed issue in the downloader with empty asset ids
 * Fixed issue where downloads are not correctly resumed

# 3.3.3

**Note** We have recently renamed our individual player SDKs as part of our
overall <PRESTOplay|http://castlabs.com/solutions/video-playback/> product suite.
Our Video Player SDK for Android is now called <PRESTOplay for Android|http://castlabs.com/products/prestoplay-mobile/>.

 * Fixed issues in the downloader plugin (**API change**)
 * Fixed synchonization issue on downloader plugin
 * Fixed issue with DASH downloads with absolute base URLs
 * Fixed issue with DASH manifest not on the same host as chunks
 * Fixed issue with HTTP 307 redirects on older devices

# 3.3.2

 * Improved content type detection for content played from Azure Media Services
 * Fixed issue with audio-only live playback
 * Improved content type detection in the Downloader Plugin
 * Fixed issue with init segment downloads in the Downloader Plugin
 * Added basic SmoothStreaming support in the Downloader Plugin (beta)
 * Fixed crash in Subtitle Plugin when subtiles tracks are switched very quickly

# 3.3.1

 * Fixed issue in SDK proguard configuration

# 3.3.0
 * Fixed issue with manual quality selection for HLS playback
 * Added `INTENT_PREFERRED_LANGUAGE` and `PREFFERED_TRACK` to allow default audio and subtitle
   track selection based on a selected language.

# 3.2.3

 * Added an option to wait for pre-roll Ads playback
 * Fixed issue with WebVTT subtitles being dropped by the player
 * Fixed issue with false-positive secondary display detection
 * Fixed issue with the Audio Track selector in the Downloader Plugin

# 3.2.2

 * Differentiate the root view and the video container view of `IPlayerView` implementations (**API change**)
 * Removed `AdPlayerView`, instead `PlayerView` should be used for the ads insertion now (**API change**)
 * Added Nielsen Plugin (Beta)
 * Improved Secondary Screen Detection and added logs
 * Fixed issue with player life-cycle and avoid unnecessary creating of a new controller
 * Fixed issue with subtitle component positioning for WebVTT

# 3.2.1

 * Fixed issue with native library sizes when building with older AS versions
 * Fixed IMA resource leak

# 3.2.0

 * Added support for optional DTS Decoder plugin
 * Extended `IPlayerView` API to allow surface removing (**API change**)

# 3.1.7

 * Fixed issue where file URLs are not correctly translated to paths
 * Support fast-forward playback on all API levels

# 3.1.6

 * Fixed issue with OMA permission checks for assets with variant ids
 * Fixed issue with Seeking in local mp4 files without `sidx` boxes
 * Fixed issue with wrong audio codec name in HLS playlists

# 3.1.5

 * Updated ExoPlayer to 1.5.9-cl-1
 * Extended the Plugin API to allow access to the registered instance
 * Added support for clear and encrypted ISMV file playback
 * Increased DOWNLOAD_ERROR message readability and include failed URL
 * Automatically reset player after sever playback errors (*Behaviour Change*)
 * Support for HLS multi Audio and Subtitle Tracks with the common
   Track Model
 * First Beta Release of the Youbora integration plugin

# 3.1.4

 * Updated OpenSSL native libraries
 * Added flag to enforce single DRM sessions for Widevine
 * Fixed issue when handing non-DRMtoday Widevine responses
 * Fixed issue where a custom CookieHandler is replaced

# 3.1.3

 * Integration with DRMToday Onboard
 * Fixes for the OMA/Registration workflow

# 3.1.2

 * Added support for ID3 Metadata using the `MetadataListener` interface
 * `DataSourceFactory#create()` now also takes an optional `PlayerController` instance (**API Change**)
 * Added new error type `TYPE_BEHIND_LIVE_WINDOW` that wraps around `BehindLiveWindow` exceptions
 * Added support for connectivity checks and allow the player to recover from loss of connectivity.
   This feature is off by default, but you can enable it with `PlayerSDK.ENABLE_CONNECTIVITY_CHECKS = true`
 * Fixed issue with `DrmLicenseLoader` where HD representations were not considered as a source for DRM init data
 * Added `PlayerSDK.CRASHLOG_AUTO_REPORT` to configure automatic crash reporting

# 3.1.1

 * Fixed memory leak in the OMA DRM Session

# 3.1.0

 * Improved subtitle rendering when `TextureView` is used instead of `SurfaceView`
 * Introduced the `IPlayerView` interface to build full custom player views
 * Added `SubtitlesStyle` class as a common model to customize caption rendering
 * Added subtitles preview component
 * Update ExoPlayer module to r1.5.6-cl-2 with a fix on HLS live edge calculations
 * Patched ExoPlayer to support VP9 encodings in WebM or ISOBMFF (if a hardware decoder is present)
 * Added Subtitle Preview component
 * Parse and render WebVTT styling and positioning attributes
 * Added ability to set additional request parameters for license requests

# 3.0.4

 * Improved error and connectivity checks in the Registration module

# 3.0.3

 * Fixed issue with `DrmLicenseLoader` for DASH Manifests that do not
   contain DRM init data

# 3.0.2

 * Added global configuration option to overwrite codec capabilities
   and force enable/disable fast bitrate switching
 * Added OkHttp Plugin
 * Fixed potential leak of global reference in OMA Plugin
 * Added global option to pre-scan Manifests for period base URLs'
   This can be used to play some non-spec conform Manifests where
   AdaptationSets are defined before the BaseURL
 * Fixed issue where duration was not correctly reported for side-loaded
   subtitle tracks
 * Added support to load offline licenses without starting playback
   (see Documentation and `DrmLicenseLoader` class)

# 3.0.1

 * Fixed regression where an Exception is raised when `getDuration`
   is called before the player is initialized.

# 3.0.0

 * Fixed incorrectly calculated HLS live edge
 * Added additional demos application
 * Enabled Playready DRM on devices that support it
 * Fixed issue with thread synchronization and improved initial startup time
 * Fixed issue with auth token upfront authentication for Widevine and Playready
 * Extracted `Drm` enum type from DrmTodayConfiguration (**API Change**)
 * Added DTS and Dolby audio support for passthrough based on device audio capabilities.
 * Removed filter for DTS and Dolby audio tracks. Hence `PlayerController.getAudioTracks`
   will return all the tracks in the manifest.
 * Removed the explicit security level setting in `DrmTodayConfiguration` (**API change**)
 * Extended SDK Documentation
 * Fixed library loading issue on some older devices


# 3.0.0-beta1

 * Added support to dynamically create Widevine CENC headers from Playready
   scheme-data
 * Allow to use a single DRM session for Widevine on TEST and STAGING if an
   asset ID is present
 * Enable offline key storage (see `DrmTodayConfiguration.offlineId` and
   `KeyStore`)
 * Added `onDisplayChanged` callback in `PlayerListener` (**API Change**)
 * Added support to handle secondary displays (see
   `PlayerSDL.SECONDARY_DISPLAY`)
 * Added support for background playback using the `PlayerService`
 * Updated and documented the player views lifecycle management and rewrote the
   `PlayerViewLifecycleDelegate` API (**API Change**). See the API
   documentation for `PlayerView` and `PlayerViewLifecycleDelegate` to adopt to
   the new API.
 * Expose an API to remove/reattach/hide the current surface view in
   `PlayerView`
 * Added workaround to deal with empty timescale fields in SIDX boxes
 * Removed unused and deprecated `videoID` parameter from DRMToday
   configuration
 * Added Crashlytics-Plugin to simplify Fabric/Crashlytics integration

# 3.0.0-alpha9

 * Updated ExoPlayer to 1.5.3-cl-1
 * Added support to fast-forward playback on Android M
 * Added support to side-load subtitle tracks via the `PlayerController` or as
   Intent Bundle parameter
 * Added support for extended Subtitles using the castLabs subtitles plugin
 * Initialize the default cookie manager to handle cookies required during
   download
 * Added ability to set the audio track volume through the player controller
 * Removed the `UpdateListener` and added a `onPlaybackPositionChanged`
   `PlayerListener` (API Change!)
 * Added the `StreamingEventListener` to get callbacks about format changes
   (video/audio) and download statistics.  (see `StreamingEventListener` and
   `PlayerController.addStreamingEventListener()`)
 * Cleanup and document of the `CastlabsPlayerException` and general error
   handling. All castlabs exceptions that are passed through the
   `PlayerListener` now contain a documented error code and cause.
 * Fixed issue with content format detection where the URL contains query
   parameters
 * Added support to add query and header parameters that are send with each
   media content request (see PlayerController#getDataSourceFactory() or the
   `Bundle` parameters documented in `PlayerController.open(Bundle)`)
 * Removed the usage of Manifest Meta-Data for configuration. The SDK and the
   Player are globally configured through static variables in code.
 * Added the ability to set the Audio Track volume from the `PlayerController`
 * Allow to save the playback state including query parameters and side loaded
   subtitle tracks to a bundle (see `PlayerController.saveState(Bundle)`)
 * Allow to start playback using a bundle (see `PlayerController.open(Bundle)`

# 3.0.0-alpha8

 * Fixed regression where local/remote mp4 playback was initialized on the
   wrong thread

# 3.0.0-alpha7

 * Integrated support for ExoPlayer Subtitles track renderer
 * Update Track and Meta-data model (API change!)
 * Renamed INTENT_PATH_TO_PLAY to INTENT_URL
 * Moved support for scale mode (fit, crop, stretch) from the player
   controller to the PlayerView class
 * Added support to use a TextureView instead of a SurfaceView for
   unprotected content. This can be configured on the PlayerView
 * Moved classes from com.castlabs.android.player.hardware to parent
   package (API change!)
 * UpdateListener is using a custom track renderer instead of a thread
 * Moved Dialog Fragment into com.castlabs.android.views package and consolidated the API
 * Load libraries and initialise the SDK in a background thread to improve application
   startup time and comply with StrictMode rules
