package com.castlabs.sdk.analytics_demo.activities

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat
import android.util.TypedValue
import android.view.Window
import com.castlabs.android.SdkConsts
import com.castlabs.android.drm.Drm
import com.castlabs.android.drm.DrmTodayConfiguration
import com.castlabs.sdk.analytics_demo.databinding.ActivityMainBinding
import com.castlabs.sdk.analytics_demo.recycle.DemoAdapter
import com.castlabs.sdk.analytics_demo.recycle.DemoData
import com.castlabs.sdk.analytics_demo.utils.BundleBuilder
import com.castlabs.sdk.ima.ImaAdRequest

class MainActivity : AppCompatActivity() {

	private lateinit var binding: ActivityMainBinding

    override fun onCreate(savedInstanceState: Bundle?) {
		super.onCreate(savedInstanceState)
		binding = ActivityMainBinding.inflate(layoutInflater)
		setContentView(binding.root)
		initSwitch()
		initDemo()
    }

	private fun initSwitch() {
		binding.swVimond.setOnCheckedChangeListener { _, isChecked ->
			DemoAdapter.includeVimondMetadata = isChecked
		}
	}

	private fun initDemo() {

		val demoData = ArrayList<DemoData>()

		demoData.add(DemoData(
			"Simple Clear Playback",
			"Plays an unencrypted stream",
			BundleBuilder(false, "Simple Clear Playback")
				.put(SdkConsts.INTENT_URL, "https://demo.cf.castlabs.com/media/TOS/abr/Manifest_clean_sizes.mpd")
				.put(BundleBuilder.VIMOND_ASSET_ID, 180278)
				.put(BundleBuilder.VIMOND_SUB, 5125125)
				.get(),
			false
		))

		demoData.add(DemoData(
			"Simple Clear Playback - No Autoplay",
			"Plays an unencrypted stream without autoplay",
			BundleBuilder(false, "Simple Clear Playback - No Autoplay")
				.put(SdkConsts.INTENT_URL, "https://demo.cf.castlabs.com/media/TOS/abr/Manifest_clean_sizes.mpd")
				.put(SdkConsts.INTENT_START_PLAYING, false)
				.put(BundleBuilder.VIMOND_ASSET_ID, 180278)
				.put(BundleBuilder.VIMOND_SUB, 5125125)
				.get(),
			false
		))

		demoData.add(DemoData(
			"DASH Live Clear Playback",
			"Plays an unencrypted live DASH stream",
			BundleBuilder(true, "DASH Live Clear Playback")
				.put(SdkConsts.INTENT_URL, "https://livesim.dashif.org/livesim/testpic_2s/Manifest.mpd")
				.put(BundleBuilder.VIMOND_ASSET_ID, 181159)
				.put(BundleBuilder.VIMOND_SUB, 5125125)
				.get(),
			false
		))

		demoData.add(DemoData(
			"Simple Clear Playback - IMA Ads",
			"Plays an unencrypted stream with IMA ads",
			BundleBuilder(false, "Simple Clear Playback - IMA Ads")
				.put(SdkConsts.INTENT_URL, "https://demo.cf.castlabs.com/media/TOS/abr/Manifest_clean_sizes.mpd")
				.put(SdkConsts.INTENT_ADVERTS_DATA, ImaAdRequest("https://pubads.g.doubleclick.net/gampad/ads?sz=640x480&iu=/124319096/external/ad_rule_samples&ciu_szs=300x250&ad_rule=1&impl=s&gdfp_req=1&env=vp&output=vmap&unviewed_position_start=1&cust_params=deployment%3Ddevsite%26sample_ar%3Dpremidpost&cmsid=496&vid=short_onecue&correlator=").toAdRequest())
				.put(BundleBuilder.VIMOND_ASSET_ID, 180278)
				.put(BundleBuilder.VIMOND_SUB, 5125125)
				.get(),
			false
		))

		demoData.add(DemoData(
			"Simple Clear Playback - IMA Skippable Ads",
			"Plays an unencrypted stream with IMA skippable ads",
			BundleBuilder(false, "Simple Clear Playback - IMA Skippable Ads")
				.put(SdkConsts.INTENT_URL, "https://demo.cf.castlabs.com/media/TOS/abr/Manifest_clean_sizes.mpd")
				.put(SdkConsts.INTENT_ADVERTS_DATA, ImaAdRequest("https://pubads.g.doubleclick.net/gampad/ads?sz=640x480&iu=/124319096/external/single_ad_samples&ciu_szs=300x250&impl=s&gdfp_req=1&env=vp&output=vast&unviewed_position_start=1&cust_params=deployment%3Ddevsite%26sample_ct%3Dskippablelinear&correlator=").toAdRequest())
				.put(BundleBuilder.VIMOND_ASSET_ID, 180278)
				.put(BundleBuilder.VIMOND_SUB, 5125125)
				.get(),
			false
		))

		demoData.add(DemoData(
			"DASH DRM - IMA Ads",
			"Plays an encrypted stream with IMA ads",
			BundleBuilder(false, "DASH DRM - IMA Ads")
				.put(SdkConsts.INTENT_URL, "https://demo.cf.castlabs.com/media/tos_new/DEMO.mpd?v=2")
				.put(SdkConsts.INTENT_ADVERTS_DATA, ImaAdRequest("https://pubads.g.doubleclick.net/gampad/ads?sz=640x480&iu=/124319096/external/ad_rule_samples&ciu_szs=300x250&ad_rule=1&impl=s&gdfp_req=1&env=vp&output=vmap&unviewed_position_start=1&cust_params=deployment%3Ddevsite%26sample_ar%3Dpremidpost&cmsid=496&vid=short_onecue&correlator=").toAdRequest())
				.put(SdkConsts.INTENT_DRM_CONFIGURATION, DrmTodayConfiguration.Builder(
					DrmTodayConfiguration.DRMTODAY_STAGING,
					"purchase",
					"p0",
					"six",
					null,
					Drm.Widevine).get())
				.put(BundleBuilder.VIMOND_ASSET_ID, 180278)
				.put(BundleBuilder.VIMOND_SUB, 5125125)
				.get(),
			false
		))

		demoData.add(DemoData(
			"Simple Clear Playback - Offset",
			"Plays an unencrypted stream which Starts with 30 sec offset",
			BundleBuilder(false, "Simple Clear Playback - Offset")
				.put(SdkConsts.INTENT_URL, "https://demo.cf.castlabs.com/media/TOS/abr/Manifest_clean_sizes.mpd")
				.put(SdkConsts.INTENT_POSITION_TO_PLAY, 30_000_000L)
				.put(BundleBuilder.VIMOND_ASSET_ID, 180278)
				.put(BundleBuilder.VIMOND_SUB, 5125125)
				.get(),
			false
		))

		demoData.add(DemoData(
			"DASH DRM - Manifest Not Found",
			"Content manifest not found error",
			BundleBuilder(false, "DASH DRM - Manifest Not Found")
				.put(SdkConsts.INTENT_CONTENT_TYPE, SdkConsts.CONTENT_TYPE_DASH)
				.put(SdkConsts.INTENT_URL, "https://demo.cf.castlabs.com/media/tos_new/notfound")
				.put(SdkConsts.INTENT_DRM_CONFIGURATION, DrmTodayConfiguration.Builder(
					DrmTodayConfiguration.DRMTODAY_STAGING,
					"purchase",
					"p0",
					"six",
					null,
					Drm.Widevine).get())
				.put(BundleBuilder.VIMOND_ASSET_ID, 180278)
				.put(BundleBuilder.VIMOND_SUB, 5125125)
				.get(),
			false
		))

		val adapter = DemoAdapter(demoData)
		binding.rvDemo.adapter = adapter
		binding.rvDemo.layoutManager = LinearLayoutManager(this)
	}
}
