package com.castlabs.sdk.analytics_demo.utils

import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.converter.scalars.ScalarsConverterFactory
import java.util.concurrent.TimeUnit

object APIClient {

	private const val baseUrl = "http://localhost/"
	private var retrofit: Retrofit? = null

	fun getClient() : Retrofit {

		if (retrofit == null) {

			val okHttpClient = OkHttpClient().newBuilder()
				.connectTimeout(30, TimeUnit.SECONDS)
				.readTimeout(30, TimeUnit.SECONDS)
				.writeTimeout(30, TimeUnit.SECONDS)
				.build()

			retrofit = Retrofit.Builder()
				.baseUrl(baseUrl)
				.client(okHttpClient)
				.addConverterFactory(ScalarsConverterFactory.create())
				.build()
		}

		return retrofit!!
	}
}
