package com.castlabs.sdk.broadpeak_demo;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;

import com.castlabs.analytics.AnalyticsMetaData;
import com.castlabs.android.SdkConsts;
import com.castlabs.android.player.PlayerConfig;
import com.castlabs.sdk.broadpeak.BroadpeakPlugin;

import java.util.Arrays;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import tv.broadpeak.smartlib.session.streaming.StreamingSessionOptions;

public class MainActivity extends AppCompatActivity {
	public static final String INTENT_PLAYLIST = "INTENT_PLAYLIST";

	private Demo[] DEMOS = new Demo[]{
			new Demo("tvr", "https://pf7.broadpeak-vcdn.com/bpk-tv/tvr-srt/default/index.mpd",
					SimplePlaybackDemo.class,
					new BundleBuilder(true, "TVR")
							.put(SdkConsts.INTENT_URL, "https://pf7.broadpeak-vcdn.com/bpk-tv/tvr-srt/default/index.mpd")
							.get()),

			new Demo("France3", "https://pf7.broadpeak-vcdn.com/bpk-tv/France3/default/index.mpd",
					SimplePlaybackDemo.class,
					new BundleBuilder(true, "France3")
							.put(SdkConsts.INTENT_URL, "https://pf7.broadpeak-vcdn.com/bpk-tv/France3/default/index.mpd")
							.get()),

			new Demo("Arte", "https://pf7.broadpeak-vcdn.com/bpk-tv/arte-srt/default/index.mpd",
					SimplePlaybackDemo.class,
					new BundleBuilder(true, "Arte")
							.put(SdkConsts.INTENT_URL, "https://pf7.broadpeak-vcdn.com/bpk-tv/arte-srt/default/index.mpd")
							.get()),

			new Demo("FranceInfo", "https://pf7.broadpeak-vcdn.com/bpk-tv/FranceInfo/default/index.mpd",
					SimplePlaybackDemo.class,
					new BundleBuilder(true, "FranceInfo")
							.put(SdkConsts.INTENT_URL, "https://pf7.broadpeak-vcdn.com/bpk-tv/FranceInfo/default/index.mpd")
							.get()),

			new Demo("SingleControllerPlaylist demo - live", "Creates a playlist with 5 items. This demo uses the SingleControllerPlaylist.",
				ConcatenatingPlaybackDemo.class,
				new BundleBuilder()
					.put(INTENT_PLAYLIST,
						new PlayerConfig[]{
							new PlayerConfig.Builder("https://pf7.broadpeak-vcdn.com/bpk-tv/tvr-srt/default/index.mpd").get(),
							new PlayerConfig.Builder("https://pf7.broadpeak-vcdn.com/bpk-tv/France3/default/index.mpd").get(),
							new PlayerConfig.Builder("https://pf7.broadpeak-vcdn.com/bpk-tv/tvr-srt/default/index.mpd").get(),
							new PlayerConfig.Builder("https://pf7.broadpeak-vcdn.com/bpk-tv/France3/default/index.mpd").get(),
							new PlayerConfig.Builder("https://pf7.broadpeak-vcdn.com/bpk-tv/France3/scte35-time/index.mpd").get(),
						}
					)
					.get()),

			new Demo("SingleControllerPlaylist demo - VOD", "Creates a playlist with 2 items. This demo uses the SingleControllerPlaylist.",
				ConcatenatingPlaybackDemo.class,
				new BundleBuilder()
					.put(INTENT_PLAYLIST,
						new PlayerConfig[]{
							new PlayerConfig.Builder("https://pf7.broadpeak-vcdn.com/bpk-vod/vod1/default/Broadtatou/Broadtatou/index.mpd").get(),
							new PlayerConfig.Builder("https://pf7.broadpeak-vcdn.com/bpk-vod/vod1/default/Eurovision/Eurovision/index.mpd").get(),
						}
					)
					.get()),

			new Demo("Simple Playback (Clear)", "Plays an unencrypted DASH VoD stream.",
					SimplePlaybackDemo.class,
					new BundleBuilder(false, "ToS")
							.put(SdkConsts.INTENT_URL, "http://demo.cf.castlabs.com/media/TOS/abr/Manifest_clean_sizes.mpd")
							.get()),

			new Demo("Live Playback (Clear)", "Plays an unencrypted DASH live stream.",
					SimplePlaybackDemo.class,
					new BundleBuilder(true, "Simulator")
							.put(SdkConsts.INTENT_URL, "http://livesim.dashif.org/livesim/testpic_2s/Manifest.mpd")
							.get()),

			new Demo("Dual ToS + ToS with offset 30s", "Plays clear assets side by side.",
					TwinPlayerDemo.class,
					new BundleBuilder()
							.put(TwinPlayerDemo.BUNDLE_1,
									new PlayerConfig.Builder("http://demo.cf.castlabs.com/media/TOS/abr/Manifest_clean_sizes.mpd")
											.audioAttributes(SdkConsts.AUDIO_ATTRIBUTES_FOCUS_DISABLED)
											.get())
							.put(TwinPlayerDemo.BUNDLE_2,
									new PlayerConfig.Builder("http://demo.cf.castlabs.com/media/TOS/abr/Manifest_clean_sizes.mpd")
											.audioAttributes(SdkConsts.AUDIO_ATTRIBUTES_FOCUS_DISABLED)
											.positionUs(30_000_000)
											.get())
							.get()),

			new Demo("SSAI Live Playback (Clear)", "Plays a live stream with SSAI",
				SimplePlaybackDemo.class,
				new BundleBuilder(true, "bpkiofficial")
					.put(SdkConsts.INTENT_URL, "https://stream.broadpeak.io/7750ca3559e5b8e12a25f547bc57c6b0/out/v1/6e0f649095ca4131b16bd0f877048629/index.mpd")
					.get()),

			new Demo("SSAI VoD 1", "Plays a vod stream with SSAI",
				SimplePlaybackDemo.class,
				new BundleBuilder(true, "City")
					.put(SdkConsts.INTENT_URL, "https://stream.broadpeak.io/7750ca3559e5b8e11e4e245aadf12dcc/bpk-vod/vod20/output01/City/City/index.mpd")
					.get()),

			new Demo("SSAI VoD 2", "Plays a vod stream with SSAI",
				SimplePlaybackDemo.class,
				new BundleBuilder(true, "City")
					.put(SdkConsts.INTENT_URL, "https://stream.broadpeak.io/7750ca3559e5b8e1070bb3a37472b00c/bpk-vod/vod20/output01/City/City/index.mpd")
					.get()),

			new Demo("SSAI Playlist demo", "Creates a playlist with 3 items. 1 Live and 2 VoD",
				ConcatenatingPlaybackDemo.class,
				new BundleBuilder()
					.put(INTENT_PLAYLIST,
						new PlayerConfig[]{
							new PlayerConfig.Builder("https://stream.broadpeak.io/7750ca3559e5b8e12a25f547bc57c6b0/out/v1/6e0f649095ca4131b16bd0f877048629/index.mpd")
								.get(),
							new PlayerConfig.Builder("https://stream.broadpeak.io/7750ca3559e5b8e11e4e245aadf12dcc/bpk-vod/vod20/output01/City/City/index.mpd")
								.get(),
							new PlayerConfig.Builder("https://stream.broadpeak.io/7750ca3559e5b8e1070bb3a37472b00c/bpk-vod/vod20/output01/City/City/index.mpd")
								.get(),
						}
					)
					.get()),

			new Demo("Thumbnail Slider Demo", "Demonstrates how to use the StandaloneThumbnailProvider with a slider to fetch thumbnails.",
				ThumbnailSliderDemo.class,
				new BundleBuilder()
					.put(ThumbnailSliderDemo.BUNDLE_STREAM_URL, "https://pf7.broadpeak-vcdn.com/bpk-tv/France3/default/index.mpd")
					.put(ThumbnailSliderDemo.BUNDLE_CONTENT_DURATION_MS, 5 * 60_000L)
					.get()),
	};


	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		ListView demosList = (ListView) findViewById(R.id.demos_list);
		List<Demo> demos = Arrays.asList(DEMOS);
		final ArrayAdapter<Demo> demoAdapter = new ArrayAdapter<Demo>(this, R.layout.demo_list_item, demos) {
			@Override
			@NonNull
			public View getView(int position, View convertView, @NonNull ViewGroup parent) {
				View view = convertView == null ? getLayoutInflater().inflate(R.layout.demo_list_item, parent, false) : convertView;
				Demo item = getItem(position);
				if (item != null) {
					((TextView) view.findViewById(R.id.title)).setText(item.name);
					((TextView) view.findViewById(R.id.description)).setText(item.description);
				}
				return view;
			}
		};

		demosList.setAdapter(demoAdapter);
		demosList.setOnItemClickListener(new AdapterView.OnItemClickListener() {
			@Override
			public void onItemClick(AdapterView<?> parent, View view, final int position, long id) {
				Demo item = demoAdapter.getItem(position);
				if (item != null) {
					item.start(MainActivity.this);
				}
			}
		});
	}

	static class Demo {
		public final String name;
		private final String description;
		private final Class<? extends Activity> activityClass;
		private final Bundle bundle;

		Demo(String name, String description, Class<? extends Activity> activityClass, Bundle bundle) {
			this.name = name;
			this.description = description;
			this.activityClass = activityClass;
			this.bundle = bundle;
		}

		void start(Context context) {
			context.startActivity(new Intent(context, activityClass).putExtras(bundle));
		}
	}

	private static class BundleBuilder {
		private final Bundle bundle;

		BundleBuilder() {
			this.bundle = new Bundle();
		}

		BundleBuilder(boolean live, String assetId) {
			this();

			// Create Analytics Metadata for Broadpeak
			final Bundle customParameters = new Bundle();
			customParameters.putString("name", "value");
			//customParameters.putString("pre_startup_time", "in_ms");

			// Options
			final SparseArray<Object> options = new SparseArray<Object>();
			options.put(StreamingSessionOptions.GDPR_PREFERENCE, StreamingSessionOptions.GDPR_CLEAR);
			//options.put(StreamingSessionOptions.USERAGENT_AD_EVENT, "useragent");
			//options.put(StreamingSessionOptions.SESSION_KEEPALIVE_FREQUENCY, 5000);
			final Bundle adParameters = new Bundle();
			adParameters.putString("client", "prestoplay-demo");

			final AnalyticsMetaData metadata = new BroadpeakPlugin.MetadataBuilder(live, assetId)
					.customParameters(customParameters)
					.options(options)
					.adParameters(adParameters)
					// Optional: Disable precache
					.precache(false)
					.get();
			put(SdkConsts.INTENT_ANALYTICS_DATA, metadata);
		}

		BundleBuilder put(String key, String value) {
			bundle.putString(key, value);
			return this;
		}

		BundleBuilder put(String key, int value) {
			bundle.putInt(key, value);
			return this;
		}

		BundleBuilder put(String key, boolean value) {
			bundle.putBoolean(key, value);
			return this;
		}

		BundleBuilder put(String key, Parcelable value) {
			bundle.putParcelable(key, value);
			return this;
		}

		BundleBuilder put(String key, Parcelable[] value) {
			bundle.putParcelableArray(key, value);
			return this;
		}

		BundleBuilder put(String key, long value) {
			bundle.putLong(key, value);
			return this;
		}

		Bundle get() {
			return bundle;
		}

	}
}
