package com.castlabs.sdk.castdemo;

import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.NotificationOptions;

import android.content.Context;

import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class CastOptionsProvider implements OptionsProvider {

	@NonNull
	@Override
	public CastOptions getCastOptions(@NonNull Context context) {

		NotificationOptions notificationOptions = new NotificationOptions.Builder()
				.setTargetActivityClassName(ExpandedControlsActivity.class.getName())
				.build();

		CastMediaOptions mediaOptions = new CastMediaOptions.Builder()
				.setNotificationOptions(notificationOptions)
				.setExpandedControllerActivityClassName(ExpandedControlsActivity.class.getName())
				.build();

		return new CastOptions.Builder()
				.setReceiverApplicationId(DemoApp.RECEIVER_APPLICATION_ID)
				.setCastMediaOptions(mediaOptions)
				.build();
	}

	@Override
	@Nullable
	public List<SessionProvider> getAdditionalSessionProviders(@NonNull Context context) {
		return null;
	}
}
