package com.castlabs.sdk.castdemo;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.appcompat.app.AppCompatActivity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;

import com.castlabs.android.SdkConsts;
import com.castlabs.android.drm.Drm;
import com.castlabs.android.drm.DrmConfiguration;
import com.castlabs.android.drm.DrmTodayConfiguration;
import com.castlabs.sdk.ima.ImaAdRequest;

import java.util.Arrays;
import java.util.List;

public class MainActivity extends AppCompatActivity {

	private static final String TAG = "MainActivity";

	private static Demo[] DEMOS = new Demo[]{
			new Demo("Simple Playback (Clear)", "Plays an unencrypted stream using a PlayerView without any additional controls or callbacks.",
					SimplePlaybackDemo.class,
					new BundleBuilder()
							.put(SdkConsts.INTENT_URL, "http://demo.cf.castlabs.com/media/TOS/abr/Manifest_clean_sizes.mpd")
							.get()),

			new Demo("Simple Playback", "Plays stream protected with WV",
				SimplePlaybackDemo.class,
				new BundleBuilder()
					.put(SdkConsts.INTENT_URL, "http://demo.cf.castlabs.com/media/TOS/DASH/DEMO.mpd")
					.put(SdkConsts.INTENT_DRM_CONFIGURATION, new DrmTodayConfiguration.Builder(
						DrmTodayConfiguration.DRMTODAY_STAGING,
						"purchase",
						"sessionId",
						"six",
						"dasheverywhere_demo",
						Drm.Widevine
					).get())
					.get()),

			new Demo("Widevine DRM proxy (HDCP + secure)", "Uses Googles widevine test proxy",
					SimplePlaybackDemo.class,
					new BundleBuilder()
							.put(SdkConsts.INTENT_URL, "https://storage.googleapis.com/wvmedia/cenc/h264/tears/tears.mpd")
							.put(SdkConsts.INTENT_DRM_CONFIGURATION,
									new DrmConfiguration.Builder()
										.url("https://proxy.uat.widevine.com/proxy?video_id=efd045b1eb61888a&provider=widevine_test")
										.playClearSamplesWithoutKeys(true)
										.drm(Drm.Widevine)
										.get())
							.get()),

			new Demo("Simple Playback (IMA Ads)", "Loads and plays single pre-roll, and mid-rolls ads during content playback.",
					SimplePlaybackDemo.class,
					new BundleBuilder()
							.put(SdkConsts.INTENT_URL, "http://demo.cf.castlabs.com/media/TOS/abr/Manifest_clean_sizes.mpd")
							.put(SdkConsts.INTENT_ADVERTS_DATA, new ImaAdRequest("//pubads.g.doubleclick.net/gampad/ads?sz=640x480&iu=/124319096/external/ad_rule_samples&ciu_szs=300x250&ad_rule=1&impl=s&gdfp_req=1&env=vp&output=xml_vmap1&unviewed_position_start=1&cust_params=sample_ar%3Dpremidpostpod%26deployment%3Dgmf-js&cmsid=496&vid=short_onecue&correlator=" + System.currentTimeMillis()).toAdRequest())
							.get())
	};


	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		ListView demosList = (ListView) findViewById(R.id.demos_list);
		List<Demo> demos = Arrays.asList(DEMOS);
		final ArrayAdapter<Demo> demoAdapter = new ArrayAdapter<Demo>(this, R.layout.demo_list_item, demos) {
			@Override
			public View getView(int position, View convertView, ViewGroup parent) {
				View view = convertView == null ? getLayoutInflater().inflate(R.layout.demo_list_item, parent, false) : convertView;
				Demo item = getItem(position);
				((TextView) view.findViewById(R.id.title)).setText(item.name);
				((TextView) view.findViewById(R.id.description)).setText(item.description);
				return view;
			}
		};

		demosList.setAdapter(demoAdapter);
		demosList.setOnItemClickListener(new AdapterView.OnItemClickListener() {
			@Override
			public void onItemClick(AdapterView<?> parent, View view, final int position, long id) {
				demoAdapter.getItem(position).start(MainActivity.this);
			}
		});


		// Custom dialog
		/*
		SubtitleStyleDialog dialog = new SubtitleStyleDialog(this);

		dialog.setOnDialogSubmitListener(new SubtitleStyleDialog.OnDialogSubmitListener() {
			@Override
			public void onDialogSubmit(SubtitleStyleDialog dialog) {
				Log.d(TAG, "background: " + dialog.colorsAdapter.getItem(dialog.spinnerBackgroundColor.getSelectedItemPosition()));
				Log.d(TAG, "foreground: " + dialog.colorsAdapter.getItem(dialog.spinnerForegroundColor.getSelectedItemPosition()));
				Log.d(TAG, "edge: " + dialog.colorsAdapter.getItem(dialog.spinnerEdgeColor.getSelectedItemPosition()));
				Log.d(TAG, "window: " + dialog.colorsAdapter.getItem(dialog.spinnerWindowColor.getSelectedItemPosition()));

				Log.d(TAG, "edge type: " + dialog.edgeTypesAdapter.getItem(dialog.spinnerEdgeType.getSelectedItemPosition()));
				Log.d(TAG, "font scale: " + dialog.textViewScale.getText());
				dialog.dismiss();
			}
		});

		dialog.show();
		*/
	}


	static class Demo {
		public final String name;
		public final String description;
		private final Class<? extends Activity> activityClass;
		private final Bundle bundle;

		Demo(String name, String description, Class<? extends Activity> activityClass, Bundle bundle) {
			this.name = name;
			this.description = description;
			this.activityClass = activityClass;
			this.bundle = bundle;
		}

		void start(Context context) {
			context.startActivity(new Intent(context, activityClass).putExtras(bundle));
		}
	}


	static class BundleBuilder {
		private final Bundle bundle;

		BundleBuilder() {
			this.bundle = new Bundle();
		}

		BundleBuilder put(String key, String value) {
			bundle.putString(key, value);
			return this;
		}

		BundleBuilder put(String key, int value) {
			bundle.putInt(key, value);
			return this;
		}

		BundleBuilder put(String key, boolean value) {
			bundle.putBoolean(key, value);
			return this;
		}

		BundleBuilder put(String key, Parcelable value) {
			bundle.putParcelable(key, value);
			return this;
		}

		Bundle get() {
			return bundle;
		}
	}
}
