package com.castlabs.sdk.demos;

import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;
import android.view.View;

import com.castlabs.sdk.debug.DebugPlugin;
import com.castlabs.sdk.debug.DebugPlugin.DebugOverlayPosition;
import com.castlabs.sdk.debug.OverlayControllerComponent;
import com.castlabs.sdk.demos.databinding.ActivityDebugPluginBinding;

import java.util.HashMap;

public class DebugPluginActivity extends AppCompatActivity {

	private ActivityDebugPluginBinding viewBinding;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		viewBinding = ActivityDebugPluginBinding.inflate(getLayoutInflater());
		setContentView(viewBinding.getRoot());
		initializeDebugOverlayControls();
		openPlayer();
	}

	@Override
	protected void onStart() {
		super.onStart();
		viewBinding.playerView.getLifecycleDelegate().start(this);
	}

	@Override
	protected void onResume() {
		super.onResume();
		viewBinding.playerControllerView.bind(viewBinding.playerView);
		viewBinding.playerView.getLifecycleDelegate().resume();
	}

	@Override
	protected void onStop() {
		super.onStop();
		viewBinding.playerControllerView.unbind();
		viewBinding.playerView.getLifecycleDelegate().releasePlayer(false);
	}

	private void initializeDebugOverlayControls() {

		viewBinding.playerControllerView.showExtendedTrackInfo(true);

		// Show overlay upon start
		final OverlayControllerComponent overlayController = DebugPlugin.getOverlayController(viewBinding.playerView.getPlayerController());
		if (overlayController != null) {
			overlayController.enableDebugOverlay();
		}

		final View.OnClickListener clickListener = new View.OnClickListener() {
			final HashMap<View, DebugOverlayPosition> viewToPosition = new HashMap<View, DebugOverlayPosition>() {{
				put(viewBinding.btFullScreen, DebugOverlayPosition.Fullscreen);
				put(viewBinding.btLeftTop, DebugOverlayPosition.LeftTop);
				put(viewBinding.btRightTop, DebugOverlayPosition.RightTop);
				put(viewBinding.btLeftBottom, DebugOverlayPosition.LeftBottom);
				put(viewBinding.btRightBottom, DebugOverlayPosition.RightBottom);
			}};

			@Override
			public void onClick(View v) {
				final OverlayControllerComponent overlayController = DebugPlugin.getOverlayController(viewBinding.playerView.getPlayerController());
				if (overlayController == null) {
					return;
				}
				if (v == viewBinding.btShow) {
					overlayController.enableDebugOverlay();
				} else if (v == viewBinding.btHide) {
					overlayController.disableDebugOverlay();
				} else {
					final DebugOverlayPosition debugOverlayPosition = viewToPosition.get(v);
					if (debugOverlayPosition != null) {
						overlayController.setDebugOverlayPosition(debugOverlayPosition);
					}
				}
			}
		};

		viewBinding.btShow.setOnClickListener(clickListener);
		viewBinding.btHide.setOnClickListener(clickListener);
		viewBinding.btFullScreen.setOnClickListener(clickListener);
		viewBinding.btLeftTop.setOnClickListener(clickListener);
		viewBinding.btRightTop.setOnClickListener(clickListener);
		viewBinding.btLeftBottom.setOnClickListener(clickListener);
		viewBinding.btRightBottom.setOnClickListener(clickListener);
	}

	private void openPlayer() {
		Bundle playbackBundle = getIntent().getExtras();
		viewBinding.playerView.getPlayerController().open(playbackBundle);
	}
}
