package com.castlabs.sdk.mediasession_demo;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;

import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;

import java.util.Arrays;
import java.util.List;

public class MainActivity extends AppCompatActivity {
	private static Demo[] DEMOS = new Demo[] {
			new Demo(
					"Media3 Session Single Item Playback",
					"Plays an unencrypted stream and enables Media3 session control",
					SimplePlaybackDemo.class),
			new Demo(
					"Media3 Session Single Controller Playlist",
					"Creates a playlist of 3 protected items and enables Media3 session control",
					ConcatenatingPlaybackDemo.class),
			new Demo(
					"Playback Service",
					"Plays a stream using the PlayerService and allows background audio playback",
					SimplePlayServiceDemo.class),
	};

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		ListView demosList = (ListView) findViewById(R.id.demos_list);
		List<Demo> demos = Arrays.asList(DEMOS);
		final ArrayAdapter<Demo> demoAdapter = new ArrayAdapter<Demo>(this, R.layout.demo_list_item, demos) {
			@Override
			public View getView(int position, View convertView, ViewGroup parent) {
				View view = convertView == null ? getLayoutInflater().inflate(R.layout.demo_list_item, parent, false) : convertView;
				Demo item = getItem(position);
				((TextView) view.findViewById(R.id.title)).setText(item.name);
				((TextView) view.findViewById(R.id.description)).setText(item.description);
				return view;
			}
		};

		demosList.setAdapter(demoAdapter);
		demosList.setOnItemClickListener(new AdapterView.OnItemClickListener() {
			@Override
			public void onItemClick(AdapterView<?> parent, View view, final int position, long id) {
				demoAdapter.getItem(position).start(MainActivity.this);
			}
		});
	}


	static final class Demo {
		public final String name;
		public final String description;
		private final Class<? extends Activity> activityClass;

		Demo(String name, String description, Class<? extends Activity> activityClass) {
			this.name = name;
			this.description = description;
			this.activityClass = activityClass;
		}

		void start(Context context) {
			context.startActivity(new Intent(context, activityClass));
		}
	}
}
