package com.castlabs.sdk.mux_demo;

import com.castlabs.android.PlayerSDK;
import com.castlabs.demoutils.ActivityInsetManager;
import com.castlabs.sdk.ima.ImaPlugin;
import com.castlabs.sdk.mux.MuxPlugin;
import com.google.ads.interactivemedia.v3.api.ImaSdkFactory;
import com.google.ads.interactivemedia.v3.api.ImaSdkSettings;

import androidx.multidex.MultiDexApplication;

public class DemoApp extends MultiDexApplication {
	private static final String TAG = "DemoApp";

	/**
	 * Environment Key. Replace this with your own.
	 */
	private static final String MUX_CUSTOMER_KEY = "9gpohq8b4q3h14emcg5fc4lms";

	@Override
	public void onCreate() {
		super.onCreate();
		registerActivityLifecycleCallbacks(new ActivityInsetManager());

		// IMA
		// Register the IMA ads plugin
		ImaPlugin imaPlugin = new ImaPlugin();
		imaPlugin.setEnabled(true);

		// Set the IMA SDK settings
		ImaSdkSettings imaSdkSettings = ImaSdkFactory.getInstance().createImaSdkSettings();
		imaSdkSettings.setLanguage("en");
		PlayerSDK.register(imaPlugin);

		// Enable mux Analytics
		// You can pass in null here as well, but then an Environment Key must be provided
		// upon playback start through Mux's CustomerPlayerData object.
		PlayerSDK.register(new MuxPlugin(MUX_CUSTOMER_KEY));

		PlayerSDK.init(getApplicationContext());
	}
}
