# 4.0.21

## Added

- Added `sessionId` to identify the source of errors in `onError` callback (4509)
- Added `picture in picture` support for `MPEG-DASH` player on iOS (4290)

## Changed

- Improved loading of asset `variants` (4524)
- Fixed `subtitle style` not updating (4516)
- Improved `AirPlay` state detection to support `MPRemoteCommandCenter` actions (4523)
- Fixed `player release` issue caused by strong references in closures (4513)
- Retain playback state when app enters `foreground` (4518)
- Fixed missing subtitles when `AirPlay` screen mirroring is enabled (4031)

# 4.0.20

## Added

- Added support for audiovisual `background` playback policy (4506)
- Added support for Widevine DRM URL from DASH manifest (4494)
- Added `avPlayerInstance` on PlayerViewControllerAPI (4496)

## Changed

- Improved `HLS` playlist exploring for Fairplay KeyIDs `prefetching` (4447)
- Added playback `interruption` handlers to SDK system state observers (4295)
- Fixed state transition from `.ended` to `.seeking` (4487)
- Improved support for `Chromecast` Custom Receivers (4482)
- Fixed seek operation issues on `MPEG-DASH` player (4511)
- Fixed end of `seek window` computation for DASH live streams (4380)
- Improved live playback `start time` and sync (4467)
- Retain playback state when app enters `foreground` (4518)
- The request/response `modify(subject:completionHandler: (Subject?, Error?) -> Void)` method is deprecated and will be removed in the next minor release; use `modify(subject:completionHandler: (Subject?) -> Void)` instead (4499)
- Added `triggerFatalError` method to `Player API` (4499)

# 4.0.19

## Added

- Added optional `completionHandler` handler for `getThumbnail` method in `ThumbnailsAPI` (4474)
- Added DVR window boundary detection - reports `player_behind_live_window` error when playback position falls outside DVR window (4387)
- Added `isAnalyticsEnabled` flag to `PlayerAPI` to toggle analytics event collection (4452)

## Changed

- Exposed detailed `PRESTOerror` documentation (4443)
- Added `SPM` 3rd part dependencies (4353)
- Fixed `video` rendering issue when returning to the foreground (4472)
- Fixed `audio` flush after another AV app switch back to the SDK (4489)
- Improve playback startup time for offline DASH content (4470)

# 4.0.18

## Added

- Added dedicated `AirPlay` component (4449)
- Extended `track model` with variant properties for native `HLSPlayer` (4466)
- Added `PRESTOplaySDK.shared.setup` as (future) replacement for `register` method (4457)

## Changed

- Improved `state transition` handling - `stop()` while `.opening` (4464)
- Fixed `HLSPlayer` keeps downloading issue after `stop()` (4450)
- Improved hvc1 parsing and device compatibility checks for `HEVC` (4441)
- Fixed `preroll` ads not being displayed (4463)
- Improved `player state` documentation (4442)
- Fixed `race condition` in player property setters (4468)
- Fixed video rendering issue when returning to the `foreground` (4472)
- Fixed `audio` playback `cracking` for MPEG-DASH when the app is in the background (4469)

# 4.0.17

## Added

- Added `pausePlaybackOnReturnToForeground` property to `PlayerAPI` protocol and implemented in HLSPlayer (4395)
- Experimental! Added native `IFrame tracks` thumbnails preview for HLS content (4166)
- Exposed `IMA` Ad settings (4420)
- Added `lastKnownPositionInSeconds` property to `CastAPI` (4418)
- Added `PlayerConfiguration` to response modifiers (4453)

## Changed

- Fixed audio playback `cracking` for MPEG-DASH content when `Bluetooth Audio` is enabled (4392)
- Fixed live start time calculation and added `onLiveStartTime` callback (4400)
- Include `HTTP status code` in HLSPlayer error message (4426)
- Refactored error related code and added more detailed messages and data to `errors` (3684)
- Improved variant URL parsing in `HLSDownloader` (4447)
- Fixed MP4 `Downloader` state update (4434)
- Improved first `authToken` update for `DRMToday` (4448)
- Fixed `Chromecast` extra metadata passing to the receiver (4417)
- Improved documentation for error handling and clarified usage of the `onError` callback (4419)
- Fixed audio playback `cracking` for MPEG-DASH content when `Bluetooth Audio` is enabled (4410)

# 4.0.16

## Added

- Added player state signalling when `HLSInterstitial` in progress (4371)
- Added `ModifiersDemo` for request / response modifiers (4388)
- Added support for `avc3 H.264` streams (4397)

## Changed

- Fixed internal `CoreData` crash while getting persistent license key in `Fairplay` (4392)
- Improved IMA error reporting (4375)
- Fixed `onTrackModel` callback (4311)
- VTWithWidevine: Added support for `arm64` and `arm64-simulator` architectures in iOS (4347)
- Improved error message handling in `HLSPlayer` (4306)
- Aligned `DRMToday` error code and message with Android for HTTP code handling (4385)
- Fixed crash during `playback start` due to incorrect closure convention (4396)
- Fixed incorrect `Ad.podPosition` value (4391)
- Aligned `PlayerConfiguration` `startTimeMs` field type to `Double` (4416)

# 4.0.15.1

## Changed

- Fixed audio playback `cracking` for MPEG-DASH content when `Bluetooth Audio` is enabled (4392)

# 4.0.15

## Added

- Added `onDuration()` callback to `PlayerAPI` protocol (4274)

## Changed

- Fixed threading issue when switching content type on the same player instance (4350)

# 4.0.14

## Added

- Exposed `adCuePoints` property to provide access to timing information for scheduled ad breaks (4337)
- Exposed `playAdsAfterTime` property to control when scheduled ads begin playback (4342)
- Added `timeoutIntervalForDrmAcquisitionMs` to `NetworkConfiguration` (4185)
- Exposed `onCurrentTime` callback to track Ad progress and duration (4338)
- Added request and response modifiers support to `HLSDownloader` and `Fairplay` license key `prefetcher` (4348)

## Changed

- Fixed `AirPlay` state not updating when playing on audio-only device (4305)
- Fixed `Midroll` ad resuming on returning from `Learn More` (4324)
- Fixed `player.engine` not set correctly (4330)
- Dispatch current time even when playback state is `ready` (4270)
- Bumped `SmartLib` version to `05.01.01.626d008` - Broadpeak plugin (4280)
- Defined default playback rate range for each player engine (4239)
- Fixed subtitles not loaded after a subtitle client reset (4271)
- Exposed DRMToday error information in `PRESTOError` (4211)
- `IMPORTANT!` Raised minimum OS target version to `15.0` for all the supported Apple platforms (4280)
- Added variant searching for Fairplay KeyIDs in `prefetcher` (4343)
- Fixed local path formatting for downloaded content (4358)

# 4.0.13

## Changed

- Fixed `IMA` ads resuming after returning from `Control Center` or `Notification Center` (4281)
- Exposed `NetworkEngine` requests timeout parameter (4185)
- Fixed `HLS Interstitials` crash in `tvOS` (4301)
- Exposed `onStreamEventsChanged` callback with in-stream `EXT-X-DATERANGE` metadata (4310)
- Added `AnalyticsOptions` parameter to YouboraPlugin initializer (4289)
- Fixed `DownloaderParallelDemo` (4304)
- Improved `Mux Data` support: bandwidth, ads, error, metadata, rendition, live stream latency (3859)
- Fixed missing subtitle options in DASH content (4299, 4245)
- Fixed downloader state update (4335)

# 4.0.12

## Changed

- Improved `Youbora` bitrate and rendition reporting (3743)
- Improved `Youbora` error reporting (4285)
- Improved `Youbora` ads duration and playhead reporting (4263, 4264)
- Improved `Youbora` playhead reporting (4261)
- Improved `Youbora` ad resource reporting (4262)
- Added `SPMIntegration` to demo Swift Package Manager integration (4279)
- Fixed playback issues with multi-period DASH content (4254)
- Added `throwFatalErrorOnContentObscured` in PlayerAPI for obscured content due to insufficient external protection (4175)
- Fixed background playback for video content when `continueAudioPlaybackInBackground` is enabled (4273)
- Improved `screen capturing` prevention for DRM-protected content (4275)
- Added `Youbora` plugin support for App Analytics (3930)
- Fixed license modifiers for `Widevine` protected content (4287)
- Improved SDK license error reporting (4241)

# 4.0.11

## Changed

- Improved updating of `seekable time ranges` (4244)
- Added equality comparison for `onTrackModel` notifications (4244)
- Improved `Widevine` certificates storage (3995)
- Fixed midroll `ads` not displayed (4250)
- Improved `Fairplay` certificate storage (2452)
- Fixed `Fairplay` license invalidation methods (2452)
- Improved `screen capturing` prevention for DRM-protected content (4275)
- Exposed `filterIFrameTracks` flag in `Download` interface for `HLSDownloader` (4276)
- Implemented url redirection in `HLSDownloader` (4266)
- Exposed `framerate` in `Download`s `VideoRendition` for `HLSDownloader` (4276)
- Fixed VAST ads not displayed (4251)
- Added estimated download size in bytes for `HLSDownloader` (4267)
- Support `autoDetectBackground` option in the Youbora plugin (4260)
- Preserve playback rate after operations such as seek, pause and play (4173)

# 4.0.10

## Changed

- Improved `Low Latency` configuration application (3675)
- Updated `ads` listener events documentation (4207)
- Updated `metadata` related documentation (4208)
- Clarified `v3`'s `reset` method equivalent in `v4` (4209)
- Updated Youbora library to `v7.2.37` in `CastlabsYoubora` (4132)
- The `player.load()` method now replaces the current item (4215)
- Fixed wrong `state` transition from playing to paused in `tvOS` (4202)
- Added sample app showing usage of `request/response modifiers` with DRMToday backend (4225)
- Improved `Fairplay` multi-key support (4203)
- Fixed HLS `Download` removal (4203)
- Added single HLS asset `Fairplay` removal (4203)
- Fixed `authToken` for `Fairplay` assignment (4203)
- Improved `Fairplay` license key fetching by `keyID` (4203)
- Fixed default content key identifier support for `Fairplay` (4257)

# 4.0.9

## Added

## Changed

- Updated `Google IMA` to 3.23.0 for iOS (4159)
- Fixed crash when `IMA ads` were attached to a new player (4159)
- Removed `.itemReplace` playlist mode (4186)
- Improved item `loading` logic in `playlist` mode (4217)
- Applied `startTimeMs` in playlist mode (4221)
- Improved `header-based DRM` loaders (4223)
- Fixed `Xcode 16` compatibility issues (4231)
- Aligned `timing` types in `Public API` (4210)
- Exposed allow cellular access flag in `Download API` (4188)
- Initial Mux Data integration - playback and seek events (2556)
- Fixed missing `pausing` state (4202)

# 4.0.8

## Changed

- Set `liveEdgeLatency` when creating playlist (4181)
- Fixed issue with low latency settings not applying to player (4189)
- Fixed tracks not changed in multi-period DASH contents (4179)
- PlayerViewController supports single player item (4205)

# 4.0.7

## Added

- Added `onAdsState` closure property to `AdsAPI` (4161)

## Changed

- Request Fairplay authorization key when it expires (4124)
- PlayerViewController supports playlist functionality. (4136)
- Aligned playlist behavior with Android (4137)
- Improved playback stats (4117)
- Improved network error handling (4088)
- Fixed PlayerViewController instance release when using SwiftUI (4154)
- Fixed background playback for audio-only content (4155)

# 4.0.6

## Added

- Added a method to `SubtitleAPI` to retrieve the state of a sideloaded track (4037)

## Changed

- Improved authorization logic for Airplay (4055)
- Removed `assetId` from the license request for Verimatrix integration (4134)
- Fixed Verimatrix DRM licensing issues (4135)

# 4.0.5

## Added

- Added explicit types for selecting the drm type (4116)

## Changed

- Fixed a seeking issue when replaying HLS content (4102)
- Fixed a seeking issue when playing MP4 content (4133)

# 4.0.4

## Changed

- Fixed playback of DRMToday Onboard content (4070)
- Synchronize playback state in the main thread (4079)
- Bumped iOS and tvOS minimum target version to 14.0 (4034)
- Bumped Google Ads IMA and Google Cast SDK version (4034)
- CastlabsIMA does not support `clickThroughUrl` since it was removed from Google Ads IMA (4034)
- Changed the component type of `ErrorHandler` to optional (4097)
- Fixed loop failure in mp3/mp4 contents (3820)

# 4.0.3

## Changed

- Fixed player instance release (4066)
- Updated additional track selection documentation for Downloader (4061)

# 4.0.2

## Added

- Added Header-based DRM certificate and license request (4038)
- Added support for SPM (3998)
- Expose playback stats (4039)
- Added support for Cleark Key contents (3949)
- Added license modifiers (4042)

## Changed

- Separated `AirPlay` mirroring and streaming for Subtitles plugin (4031)
- Exposed `bufferedPercentage` property in DASH contents (4017)
- Removed the HLS download task once it is completed (4030)
- Aligned state transition with the state graph (4007)

# 4.0.1

## Added

- Added `MacCatalyst` support for Intel CPUs (3980)
- Added error reporting for `stalled` and `failed` playbacks (3987)
- Added dedicated error resource unavailable `.player_resource_unavailable` (3242)
- Added dedicated warning for `Internet Connection` availability (3678)
- Added new parameter to `register()` method for setting companion sdk name and version (4041)

## Changed

- Exposed `Broadpeak` configuration options (3922)
- Added `parallel download` demo (3944)
- Fixed download UI error in `PlaymakerApp` (2023)
- `Apple TV` player, synchronize state on the main thread (3999)
- Fixed selection of audio and video renditions (3996)
- Made `.error` player state final (4015)
- Improved and unified plugins and SDK versions (4016)
- Fixed `preferredAudioLanguage` for HLSPlayer (4012)
- Improved the playback state transitions (4002)
- Exposed `bufferedPercentage` property in HLS contents (4013)
- Improved the grid thumbnail initializer (4009)
- Updated `changeIndex` for waiting playback preconditions (ads preroll, Broadpeak) (4022)

# 4.0.0

## Changed

- Merged `CastlabsVT` plugin with `CastlabsWidevine` (3862)
- Improved internal error handling (3863)
- Fixed `Chromecast` tracks mapping (3943)
- Improved `Public API` error reporting (3314)
- Fixed `onCurrentTime` rate calling in `Public API` (3942)
- Added example project showcasing support for Mac with Apple Silicon (2506)
- Clarify differences between `TTML`, `IMSC1` and `SMPTE-TT` in documentation (3913)
- Improved `SubtitlesAPI` and `CastlabsSubtitles` plugin synchronisation (3920)
- Fixed playback not finish instantly when scrolling to the end in `VTPlayer` (3915)
- Fixed playback for content using `DRMToday Onboard` (3722)
- Made request and response modifiers asynchronous (3927)
- Improved internal components communication and synchronisation (3947)
- Added error reporting to `CastlabsYoubora` (3929)
- Built and included `YouboraLib` as dynamic XCFramework (3903)
- Added missing requests in the Youbora plugin (3928)
- Fixed AD session is not released properly (3926)
- Improved `PlayerWrapper` callbacks storing (3946)
- Fixed Airplay fails for FPS with Auth token (2900)
- Exposed response type in `ResponseModifier` (3938)
- Changed product name from `PRESTOPlay` to `PRESTOplay` (3939)
- AD sessions are now reported to Conviva (3941, 3945)
- Conviva demos now correctly report sessions to Conviva (3963)
- Improved overall documentation (2992)
- Fix playback for protected HLS content (3961)
- Downloaded DASH contents now play correctly in airplane mode (3265)
- AD events are no longer sent to Youbora when ads are disabled (3962)
- Downloading DRM contents works in `PlaymakerApp` (3630)
- Revised and improved the documentation for the demos (3971)
- Allowed insecure connection for `BroadpeakDemo` (3965)
- IMA Ads menu in Demos project now displays ads correctly (3972)
- Fixed playback loop (3820)
- Added status code to network response modifier (3952)
- Added Widevine CDM to the SDK package (3967)
- Fixed Fairplay rental license storage (3919)
- Improved synchronization of player properties (3951)
- Fixed `HLSDownloader` track selection (3916)
- Improved error handling for Chromecast (3957)
- Fixed sideloaded thumbnails (3973)
- Ads now display properly in clear DASH contents (3984)
- Added network path monitor to the system component (3976)
- Renamed Conviva parameter names (3966)

# 4.0.0-rc6

## Changed

- Fixed playback error in Demos project (3849)
- Fixed session release issue (3847)
- Improved IMSC1 embedded subtitles tracks support (3866)
- Fixed release issues in the replacement method (3874)
- Fixed sideloaded subtitles track initialization and selection (3858)
- Fixed playback state is not updated (3887)
- Updated grid thumbnail initializer (3890)
- Added Conviva plugin example (3688)
- Expose chromecast media status in CastAPI (3891)
- Implemented default phone call handler (3744)
- Fixed playback not paused while ad playing (3894)
- Fixed playback failed after post-roll ad (3901)
- Made YouboraLib linked statically to `CastlabsYoubora` plugin (3778)
- Fixed FPS license request cancellation (3905)
- Added `CastlabsIMA.xcframework` to the release plugin and updated IMA demo (3691)
- Fixed VTPlayer playback issues with ad (3912)

# 4.0.0-rc5

## Changed

- Added `replace(config:)` method to `PlayerComponentProtocol` (3802)
- Added `CastlabsDASHDemo` example and update the Demos project (3693)
- Added `BroadpeakDemo` example and update the Demos project (3686)
- `TVPlayerViewController` supports iOS and is renamed to `ApplePlayerViewController` (3770)
- Improved Downloads removal for DASH and HLS streams (3736)
- Updated `CastlabsWidevine` documentation (3694)
- Updated `CastlabsVT` documentation (3692)
- Updated Broadpeak version to `04.05.03.380e6d2` (3884)
- Fixed requesting media data when a DASH stream is played to the end (2901)
- Improved track model by including media characteristics (3851)

# 4.0.0-rc4

## Changed

- Bumped minimum deployment target to 13.0 for all SDK and Plugins
- Bumped `Google Cast SDK`` for iOS to version 4.8.0
- Added `CastlabsVT.xcframework` to the release plugin (3789)
- Added `CastlabsWidevine.xcframework` to the release plugin (3795)
- Fixed DRM system selection for automatic value

# 4.0.0-rc3

## Changed

- Expose `getLiveStartTime` in PlayerViewControllerAPI. (3788)
- Fixed `seekableTimeRanges` returning wrong value. (3785)

# 4.0.0-rc2

## Changed

- Apple TV player, use PlayerAPI instance in TVPlayerViewController. (3536)
- Apple TV player, support analytic plugins. (3536)
- Apple TV player, expose the audio and subtitle track change event and api. (3674)
- Apple TV player, add onError() event and pass error code and message. (3666, 3668)
- Apple TV player, add an option to disable channel skipping in live stream. (3658)
- Fixed player returning incorrect track value. (3772)
- Expose `getLiveStartTime` for live content. (3750)
- Fixed random crash during a seek operation. (3747)
- Fixed player events spam. (3726)

# 4.0.0-rc1

## Changed

- Rewritten CastlabsApple plugin
- Rewritten CastlabsThumbnails plugin
- Rewritten CastlabsSubtitles plugin
- Rewritten CastlabsDownloader plugin
- Rewritten CastlabsChromecast plugin
- Rewritten CastlabsYoubora plugin
- Prepared for React Native integration
- Added Migration Guide from v3 to v4
- Updated examples and demos
- Updated documentation

# 4.0.0-beta20230524

## Changed

- Added track-change flag to PlayerState. (3605)
- Added http status code and uri to error data. (3662)
- Apple TV player, can use system image for action buttons. (3661)
- Support `liveConfiguration.liveEdgeLatencyMs` player configuration in HLS player and TVPlayerViewController. (3584)
- Fixed thumbnails directory is not created on tvOS device. (3676)

# 4.0.0-beta20230420

## Changed

- Apple TV player, added channel flipping protocols. (3597, 3624)
- Apple TV player, removed `eventName` from action info. (3609)
- Apple TV player, added `getCurrentTime()` method. (3618)
- Apple TV player, added `requiresLinearPlayback` option. (3619)
- Apple TV player, fixed playback continues when player closed. (3639)
- Downloader, added HLS media downloader support. (3375)

# 4.0.0-beta20230308

## Changed

- Added seek and playback status events to Apple TV player. (3601)
- Set analytics player name to CastlabsPlayer. (3554)
- Fixed app crashes when the license key is not valid. (3589)
- Fixed not seek accurately to time 00:00. (3567)
- Fixed `contentType:HLS` is not supported in PlayerConfiguration json. (3593)
