//
//  CLPlaylistFactory.h
//  mpl
//
//  Created by Emil Pettersson on 06/04/16.
//  Copyright © 2016 castLabs GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "CLPlaylist.h"

/**
 * CLPlaylistFactory class provides methods to generate a quality tree.
 */
@interface CLPlaylistFactory : NSObject

/**
 * Load manifest from given path and generate quality tree.
 */
+ (nullable CLPlaylist*)generateWithFile:(nonnull NSString*)path error:(NSError* _Nullable * _Nullable)error;

/**
 * Fetch manifest from given URL and generate quality tree.
 */
+ (void)generateWithURL:(nonnull NSString*)url
        completionBlock:(nonnull void (^)(CLPlaylist* _Nullable, NSData* _Nullable, NSError* _Nullable))block;

/**
 * Generate quality tree from the provided NSData.
 */
+ (nullable CLPlaylist*)generateWithData:(nonnull NSData*)data;

@end
