//
//  CLTrack.h
//  mpl
//
//  Created by Emil Pettersson on 06/04/16.
//  Copyright © 2016 castLabs GmbH. All rights reserved.
//

#import "CLTrack.h"

@interface CLTrack () {
    NSMutableArray<CLQuality*>* _qualities;
}

+ (nullable instancetype)trackWithType:(CLMediaType)type
                              duration:(double)duration
                                  name:(nullable NSString*)name
                              language:(nullable NSString*)language
                             qualities:(nullable NSArray<CLQuality*>*)qualities
                             andParent:(nullable __weak CLMovie*)parent;

+ (nullable instancetype)trackWithType:(CLMediaType)type
                              duration:(double)duration
                                  name:(nullable NSString*)name
                              language:(nullable NSString*)language
                       qualityCapacity:(NSUInteger)capacity
                             andParent:(nullable __weak CLMovie*)parent;

- (nullable instancetype)initWithType:(CLMediaType)type
                             duration:(double)duration
                                 name:(nullable NSString*)name
                             language:(nullable NSString*)language
                            qualities:(nullable NSArray<CLQuality*>*)qualities
                            andParent:(nullable __weak CLMovie*)parent;

- (nullable instancetype)initWithType:(CLMediaType)type
                             duration:(double)duration
                                 name:(nullable NSString*)name
                             language:(nullable NSString*)language
                      qualityCapacity:(NSUInteger)capacity
                            andParent:(nullable __weak CLMovie*)parent;

- (void)addQuality:(nonnull CLQuality*)quality;

@end
