//
//  CLMovieInternal.h
//  mpl
//
//  Created by Emil Pettersson on 06/04/16.
//  Copyright © 2016 castLabs GmbH. All rights reserved.
//

#import "CLMovie.h"

@interface CLMovie () {
    NSMutableArray<CLTrack*>* _tracks;
}

+ (nullable instancetype)movieWithTracks:(nullable NSArray<CLTrack*>*)tracks
                                duration:(double)duration
                               andParent:(nullable __weak CLPlaylist*)parent;

+ (nullable instancetype)movieWithTrackCapacity:(NSUInteger)capacity
                                       duration:(double)duration
                                      andParent:(nullable __weak CLPlaylist*)parent;

- (nullable instancetype)initWithTracks:(nullable NSArray<CLTrack*>*)tracks
                               duration:(double)duration
                              andParent:(nullable __weak CLPlaylist*)parent;

- (nullable instancetype)initWithTrackCapacity:(NSUInteger)capacity
                                      duration:(double)duration
                                     andParent:(nullable __weak CLPlaylist*)parent;

- (void)addTrack:(nonnull CLTrack*)track;

@end
