#ifndef asl_wrappers_p_h
#define asl_wrappers_p_h

#include "asl_wrappers.h"
#include <asl/Typedefs.h>
#include <asl/Sample.h>
#include <asl/DrmInterface.h>

#include <future>
#include <memory>

@interface PayloadInfo() {
    std::shared_ptr<asl::PayloadInfo> payload;
}
@property const std::shared_ptr<asl::PayloadInfo> &payload;
@end

@interface TrackSelectionInfo() {}
@property (readonly) asl::TrackSelectionInfo *trackSelection;
@end

@interface TransitionInfo() {}
@property (readonly) asl::TransitionInfo *transition;
@end

@interface SampleInfo() {}
@property (readonly) asl::SampleInfo *sample;
@end

@interface SidechannelInfo() {}
@property (readonly) asl::SidechannelInfo *sidechannel;
@end

@interface TrackInfo() {
    std::unique_ptr<const asl::TrackInfo> track;
}
@property const asl::TrackInfo *track;
@end

@interface QualityInfo() {
    std::unique_ptr<const asl::QualityInfo> quality;
}
@property const asl::QualityInfo *quality;
@end

@interface AudioQualityInfo()
@property (readonly) const asl::AudioQualityInfo *audioQuality;
@end

@interface VideoQualityInfo()
@property (readonly) const asl::VideoQualityInfo *videoQuality;
@end

@interface AudioTrackInfo() {}
@property (readonly) const asl::AudioTrackInfo *audioTrack;
@end

@interface VideoTrackInfo() {}
@property (readonly) const asl::VideoTrackInfo *videoTrack;
@end

@interface SubtitleTrackInfo() {}
@property (readonly) const asl::SubtitleTrackInfo *subtitleTrack;
@end

@interface SubtitleSegment() {
    std::unique_ptr<const asl::SubtitleSegment> subtitleSegment;
}
@property const asl::SubtitleSegment *subtitleSegment;
@end

@interface SubtitleSegmentFuture() {
    std::future<asl::SubtitleSegment> _future;
}
- (void) setFuture: (std::future<asl::SubtitleSegment>) future;
- (std::future<asl::SubtitleSegment> &) future;
@end

@interface DownloadErrorMessage()
@property asl::MessageCallbacks::DownloadErrorMessage message;
@end

@interface AbrStatMessage()
@property asl::MessageCallbacks::AbrStatMessage message;
@end

@interface PSSHEntry()
@property asl::DrmInterface::PSSHEntry entry;
@end

@interface ProtectionEntry()
@property asl::DrmInterface::ProtectionEntry entry;
@end

@interface PeriodInfo()
@property asl::PeriodInfo info;
@end

@interface PeriodCallbacks()
@property const asl::PeriodCallbacks *callbacks;
@end

@interface VTSession() {
    std::unique_ptr<asl::Session> session;
    std::unique_ptr<asl::DrmInterface> drm;
}
@end

class DrmInterfaceWrapper: public asl::DrmInterface {
public:
    DrmInterfaceWrapper(id<DrmInterface> drm)
    : drm(drm)
    {}
    
    clc::Result initWithPSSHBoxes(const PSSHVector& boxes) override;
    bool initCommonEncryption(InitSource source, const std::string &scheme, const std::string &id) override;
    bool updateCommonEncryption(InitSource source, const std::string &id, const ProtectionEntries &entries) override;
    
private:
    id<DrmInterface> drm;
};

#endif // asl_wrappers_p_h
