//
// Created by Luca Niccoli on 09/12/2020.
//
#ifndef DATA_FORMATS_H
#define DATA_FORMATS_H

#import <Foundation/Foundation.h>
#import <CoreAudio/CoreAudioTypes.h>
#import <CoreMedia/CoreMedia.h>
#import "asl_wrappers.h"
#import "BitstreamUtils.h"

@interface DataFormats : NSObject
+ (CMFormatDescriptionRef) createDescriptionForOutputType: (OutputType)type withSidechannelInfo: (SidechannelInfo*)info CF_RETURNS_RETAINED;
+ (CMSampleBufferRef)createSampleBufferFromSampleInfo: (SampleInfo *)sample withData: (NSData*)data format: (CMFormatDescriptionRef)format bitstream: (BitstreamFormat)bitstream andPtsOffset: (CMTime)offset CF_RETURNS_RETAINED;
+ (void) setAsDecodeOnly:(CMSampleBufferRef)sample;
@end

#endif // DATA_FORMAT_H
