//
//  AppDelegate.swift
//  Demos
//
//

import AVFoundation
import CastlabsApple
import CastlabsBroadpeak
import CastlabsConviva
import CastlabsIMA
import CastlabsMux
import CastlabsSubtitles
import CastlabsThumbnails
import CastlabsVT
import CastlabsYoubora
import NpawPlugin
import PRESTOplay
import SwiftUI
import UIKit

#if !os(tvOS)
    import CastlabsChromecast
    import CastlabsDownloader
#endif

@main
class AppDelegate: UIResponder, UIApplicationDelegate {
    var window: UIWindow?

    func application(
        _: UIApplication,
        didFinishLaunchingWithOptions _: [UIApplication.LaunchOptionsKey: Any]?
    )
        -> Bool
    {
        let analyticsOptions = NpawPlugin.AnalyticsOptions()
        analyticsOptions.userName = "User Name"
        let youboraSettings = YouboraSettings(accountCode: "", analyticsOptions: analyticsOptions)

        let broadpeakSettings = BroadpeakSettings(
            analyticsAddress: "YOUR-ANALYTICS-SERVER-ADDRESS",
            nanoCDNHost: "",
            domainNames: "")

        let convivaSettings = ConvivaSettings(
            customerKey: "YOUR-CUSTOMER-KEY",
            gatewayUrl: "YOUR-GATEWAY-URL")

        let muxSettings = MuxSettings(environmentKey: "YOUR-ENV-KEY")

        let plugins: [CLPluginProtocol] = [
            HLSPlugin(),
            VTPlugin(),
            SubtitlesPlugin(),
            ThumbnailsPlugin(),
            YouboraPlugin(youboraSettings),
            BroadpeakPlugin(broadpeakSettings),
            ConvivaPlugin(convivaSettings),
            IMAPlugin(),
            MuxPlugin(muxSettings),
        ]

        _ = PRESTOplaySDK.shared.setup(
            "LICENSE",
            plugins
        )

        try? AVAudioSession.sharedInstance().setCategory(.playback)

        window = UIWindow(frame: UIScreen.main.bounds)
        window?.rootViewController = UIHostingController(rootView: DemosView(demos: []))
        window?.makeKeyAndVisible()
        return true
    }
}
