//
//  PlayerViewController.swift
//  Demos
//

import AVFoundation
import SwiftUI
import PRESTOplay

struct PlayerViewController: View {
    // describe the demo configuration
    let demo: Demo
    // create player instance
    @State private var playerUIViewController: PlayerUIViewController?

    var body: some View {
        VStack {
            playerUIViewController
        }
        .onAppear() {
            playerUIViewController = PlayerUIViewController(demo: demo)
        }

        #if !os(tvOS)
        .navigationBarTitle(Text(demo.title), displayMode: .inline)
        #endif
    }
}

struct PlayerViewController_Previews: PreviewProvider {
    static var previews: some View {
        PlayerView(demo: Demo(
            title: "HLS Playback",
            description: "Basic HLS playback demo"
        ))
    }
}
