//
//  ViewController.swift
//  MuxDemo
//
//

import PRESTOplay
import CastlabsApple
import CastlabsMux
import MuxCore
import AVFoundation
import UIKit

class ViewController: UIViewController {
    // create player instance
    var player = PRESTOplaySDK.shared.player()
    var analytics: AnalyticsAPI?

    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view.
        // optional: ignore silent switch
        try? AVAudioSession.sharedInstance().setCategory(.playback)

        guard let contentURL = URL(string: "https://demo.cf.castlabs.com/media/prestohls/master.m3u8")
        else { return }

        let config = PlayerConfiguration(with: contentURL)
        player.load(config: config)

        player.onState = { [weak self] previous, state in
            guard let self else { return }
            if let error = self.player.error {
                print("Error \(error)")
                return
            }
        }
        
        addMux()    // Optional: Update custom metadata if needed.

        player.attach(to: view.layer)
        player.open(autoplay: true)
    }

    override func viewWillTransition(
        to size: CGSize,
        with coordinator: UIViewControllerTransitionCoordinator)
    {
        player.update(size: size)
    }

    func addMux() {
        analytics = PRESTOplaySDK.shared.analytics(for: player, .mux)
        guard let playerData = MUXSDKCustomerPlayerData(environmentKey: "YOUR-ENV-KEY")
        else { return }

        let videoData = MUXSDKCustomerVideoData()
        videoData.videoTitle = "Video Title"

        let customerData = MUXSDKCustomerData()
        customerData.customerPlayerData = playerData
        customerData.customerVideoData = videoData

        let muxMetadata = MuxMetadata(
            live: false,
            assetId: "assetId")
        muxMetadata.customerData = customerData
        analytics?.metadata = muxMetadata
    }
}
