//
//  CLQualityInternal.h
//  mpl
//
//  Created by Emil Pettersson on 06/04/16.
//  Copyright © 2016 castLabs GmbH. All rights reserved.
//

#import "CLQuality.h"
#import "CLResourceListBuilder.h"

@interface CLQuality ()

/**
 * Builder used to populate list of resources
 */
@property (nonnull, readonly) CLResourceListBuilder* resourceBuilder;


/// <#Description#>
/// - Parameters:
///   - builder: <#builder description#>
///   - parameters: <#parameters description#>
///   - fourCC: <#fourCC description#>
///   - identifier: <#identifier description#>
///   - type: <#type description#>
///   - bitrate: <#bitrate description#>
///   - parent: <#parent description#>
- (nullable instancetype)initWithResourceListBuilder:(nonnull CLResourceListBuilder*)builder
                                          parameters:(nullable NSString*)parameters
                                              fourCC:(nullable NSString*)fourCC
                                          identifier:(nullable NSString*)identifier
                                                type:(CLMediaType)type
                                             bitrate:(UInt32)bitrate
                                           andParent:(nullable __weak CLTrack*)parent;

@end

#pragma mark -

@interface CLCodecPrivateQuality ()

- (nullable instancetype)initWithResourceListBuilder:(nonnull CLResourceListBuilder*)builder
                                          parameters:(nullable NSString*)parameters
                                              fourCC:(nullable NSString*)fourCC
                                          identifier:(nullable NSString*)identifier
                                                type:(CLMediaType)type
                                             bitrate:(UInt32)bitrate
                                    codecPrivateData:(nullable NSData*)codecPrivateData
                                           andParent:(nullable __weak CLTrack*)parent;

@end

#pragma mark -

@interface CLAudioQuality ()

/**
 * Create CLAudioQuality class
 * @param[in] channels Number of channels
 * @param[in] sampleRate Number of samples per second
 * @param[in] bitsPerSample Number of bits per single audio sample
 */
- (nullable instancetype)initWithResourceListBuilder:(nonnull CLResourceListBuilder*)builder
                                              fourCC:(nullable NSString*)fourCC
                                          identifier:(nullable NSString*)identifier
                                             bitrate:(UInt32)bitrate
                                    codecPrivateData:(nullable NSData*)codecPrivateData
                                            channels:(UInt32)channels
                                          sampleRate:(UInt32)sampleRate
                                       bitsPerSample:(UInt32)bitsPerSample
                                           andParent:(nullable __weak CLTrack*)parent;

@end

#pragma mark -

@interface CLVideoQuality ()

/**
 * Create CLVideoQuality class
 * @param[in] width Video width
 * @param[in] height Video height
 * @param[in] naluSize Size of NALU (for non-H264 shall be 0)
 */
- (nullable instancetype)initWithResourceListBuilder:(nonnull CLResourceListBuilder*)builder
                                              fourCC:(nullable NSString*)fourCC
                                          identifier:(nullable NSString*)identifier
                                             bitrate:(UInt32)bitrate
                                    codecPrivateData:(nullable NSData*)codecPrivateData
                                               width:(UInt32)width
                                              height:(UInt32)height
                                            NALUsize:(UInt32)naluSize
                                           andParent:(nullable __weak CLTrack*)parent;

@end

#pragma mark -

@interface CLTextQuality ()

/**
 * Create CLTextQuality class
 * @param[in] width Target rendering screen width
 * @param[in] height Target rendering screen height
 * @param[in] text The actual text (if any)
 */
- (nullable instancetype)initWithResourceListBuilder:(nonnull CLResourceListBuilder*)builder
                                              fourCC:(nullable NSString*)fourCC
                                          identifier:(nullable NSString*)identifier
                                             bitrate:(UInt32)bitrate
                                               width:(UInt32)width
                                              height:(UInt32)height
                                                text:(nullable NSString*)text
                                           andParent:(nullable __weak CLTrack*)parent;

@end
