//
//  CLTrack.h
//  mpl
//
//  Created by Emil Pettersson on 06/04/16.
//  Copyright © 2016 castLabs GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "CLQuality.h"

@class CLMovie;

/**
 * CLTrack represents a media track with one or more qualities
 */
@interface CLTrack : NSObject

// TODO: Could use Cocoa language APIs to work with language codes

/**
 * Retrieve parent of track
 */
@property (nullable, readonly, weak) CLMovie* parent;

/**
 * Retrieve type of quality
 */
@property (readonly) CLMediaType type;

/**
 * Retrieve duration of track (in seconds)
 */
@property (readonly) double duration;

/**
 * String with a name identifying the track (may be nil)
 */
@property (nullable, readonly) NSString* name;

/**
 * String with the language of the track (may be nil)
 */
@property (nullable, readonly) NSString* language;

/**
 * An array with qualities for the track
 */
@property (nonnull, readonly) NSArray<CLQuality*>* qualities;

@end
