//
//  CLHttpClient.h
 
//
//  Created by Guido Parente on 05/04/2017.
//  Copyright © 2017 castLabs. All rights reserved.
//
#ifndef CLIENT_IOS_HTTPCLIENT_H
#define CLIENT_IOS_HTTPCLIENT_H

#import <Foundation/Foundation.h>

#include <clc/network/http/abstractClient.h>
#include <clc/network/http/request/postRequest.h>
#include <clc/network/http/request/getRequest.h>
#include <clc/network/http/request/putRequest.h>
#include <clc/network/http/response/response.h>

class CLHttpClient : public clc::http::AbstractClient {
    
public:
    CLHttpClient() {};
    ~CLHttpClient() {};
    virtual void setUserAgent(const clc::String &userAgent) override;
    virtual void setCustomHeaders(std::map<clc::String, clc::String> headers) override;
    
protected:
    virtual clc::Result
    doExecute(const std::shared_ptr<clc::http::AbstractRequest> &request, bool headersOnly,
              const std::shared_ptr<clc::http::Response> &response) override;
    
    virtual bool onTransferInterrupt() override;
    
private:
    clc::Result executeRequest(const std::shared_ptr<clc::http::AbstractRequest> &request, const std::shared_ptr<clc::http::Response> &response);
    clc::String m_userAgent;
    std::map<clc::String, clc::String> m_customHeaders;
};


#endif //CLIENT_IOS_HTTPCLIENT_H
