//
//  SubtitlesRendererWrapper.h
//  CastlabsSubtitles
//
//  Created by james.mcgill on 19.01.21.
//

#ifndef SubtitlesRendererWrapper_h
#define SubtitlesRendererWrapper_h

#include "SubtitlesPoolWrapper.h"
#include "CLSubtitlesStyleWrapper.h"

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface SubtitlesRendererWrapper : NSObject


-(instancetype) initWithPool:(SubtitlesPoolWrapper*) pool;

// Decide what should be rendered at the given player time
// This updates the internal model and the changes will become
// visible on the next draw call.
// Returns the player time position when the next model state change
// is expected to occur
-(UInt64) updateStateWithPosition:(UInt64) playerPosition;

// Draw the subtitles based on the current internal model state
-(void) drawWithContext:(CGContextRef) context
            withVideoSize:(CGSize) videoSize
           withCanvasSize:(CGSize) canvasSize;

// Copy player settings into subtitle renderer settings
-(void) passStyleSettings:(CLSubtitlesStyleWrapper*) settings;

@end

NS_ASSUME_NONNULL_END

#endif /* SubtitlesRendererWrapper_h */
