# Analytics

We provide pre-integrations with multiple analytics vendors. In most cases, you will only need to initialize the plugin with your account credentials and optional custom data. The SDK will take care of sending the required playback events (e.g. playback start/pause/stop, buffering, seeking, ad start/stop...) to the analytics backend.

## Youbora

`Youbora Analytics` is a comprehensive analytics and monitoring platform specifically designed for online video streaming services. It provides real-time insights and data analytics to help content providers and broadcasters understand the performance and usage of their video content.

Developed by [Nice People At Work](http://nicepeopleatwork.com/), Youbora Analytics offers a wide range of features and capabilities to track, measure, and optimize video streaming performance. It collects data from various sources, including video players, content delivery networks (CDNs), and end-user devices, and transforms that data into meaningful metrics and reports.

Our integration is validated by Nice People at Work QA.

### Integrate

To start with Youbora Analytics first register a plugin to PRESTOplay SDK:

```swift
import PRESTOplay
import CastlabsYoubora
import NpawPlugin

...

let analyticsOptions = NpawPlugin.AnalyticsOptions()
analyticsOptions.userName = "User Name"
let youboraSettings = YouboraSettings(accountCode: "...", analyticsOptions: analyticsOptions)
let youboraPlugin = YouboraPlugin(youboraSettings)
PRESTOplaySDK.shared.setup("LICENSE", [youboraPlugin])
```

The `userName` in the sample code is displayed on the `Tracking Sessions` page of the `Video Analytics` dashboard.

### Analytics instance and custom metadata

After creating an analytics instance with the player and the `.youbora` option, set the custom metadata. If you want to use custom Youbora client settings you will have to import `NpawPlugin` to your project.
The easiest way is to add it via `Podfile`:

```ruby
pod 'NpawPlugin'
```

To pass custom data:

```swift
import PRESTOplay
import CastlabsYoubora
import NpawPlugin

var analytics = PRESTOplaySDK.shared.analytics(for: player, .youbora)

...

let youboraMetadata = YouboraMetadata(
    live: false,
    assetId: "assetId")
youboraMetadata.analyticsOptions = NpawPlugin.AnalyticsOptions()
youboraMetadata.analyticsOptions?.adCustomDimension1 = "test"
youboraMetadata.analyticsOptions?.contentTitle = "test"
youboraMetadata.analyticsOptions?.autoDetectBackground = false
youboraMetadata.analyticsOptions?.userName = "User Name"
youboraMetadata.accountCode = "ACCOUNT_CODE"

analytics?.metadata = youboraMetadata
```

The `userName` in the sample code is displayed on the `Detailed Session` page of the `Video Analytics` dashboard.

To prevent the plugin from sending a `Stop` event when switching to Picture in Picture mode, set `analyticsOptions?.autoDetectBackground` to `false`.
Please check our `examples/YouboraDemo` for complete implementation.

## Broadpeak

### Integrate

Register a Broadpeak plugin to PRESTOplay SDK:

```swift
import PRESTOplay
import CastlabsBroadpeak

...

let broadpeakSettings = BroadpeakSettings(
    analyticsAddress: "YOUR-ANALYTICS-SERVER-ADDRESS",
    nanoCDNHost: "",
    domainNames: "")
let broadpeakPlugin = BroadpeakPlugin(broadpeakSettings)

PRESTOplaySDK.shared.setup("LICENSE", [broadpeakPlugin])
```

### Analytics instance and custom metadata

After creating an analytics instance with the player and the `.broadpeak` option, set the custom metadata.

```swift
var analytics = PRESTOplaySDK.shared.analytics(for: player, .broadpeak)

...

let broadpeakMetadata = AnalyticsMetadata(
    live: false,
    assetId: "assetId")
analytics.metadata = broadpeakMetadata
```

Please check our `examples/BroadpeakDemo` for complete implementation.

## Conviva

### Integrate

First, include the `ConvivaSDK` library in your project. Here is an example using CocoaPods:

```ruby
pod 'ConvivaSDK'
```

Please find a list of supported versions in `configs/deps-versions`.

Next, register the Conviva plugin to PRESTOplay SDK:

```swift
import PRESTOplay
import CastlabsConviva

...

let convivaSettings = ConvivaSettings(
    customerKey,: "YOUR-CUSTOMER-KEY",
    gatewayUrl: "YOUR-GATEWAY-URL")
let convivaPlugin = ConvivaPlugin(convivaSettings)

PRESTOplaySDK.shared.setup("LICENSE", [convivaPlugin])
```

### Analytics instance

Creating an analytics instance with the player and the `.conviva` option.

```swift
var analytics: AnalyticsAPI = PRESTOplaySDK.shared.analytics(for: player, .conviva)
```

Please check our `examples/ConvivaDemo` for complete implementation.

## Mux Data

### Integrate

First, include the `Mux-Stats-Core` library in your project. Here is an example using CocoaPods:

```ruby
pod 'Mux-Stats-Core'
```

Please find a list of supported versions in `configs/deps-versions`.

Next, register the Mux Data plugin to PRESTOplay SDK:

```swift
import PRESTOplay
import CastlabsMux

...

let muxSettings = MuxSettings(environmentKey: "YOUR-ENV-KEY")
let muxPlugin = MuxPlugin(muxSettings)

PRESTOplaySDK.shared.setup("LICENSE", [muxPlugin])
```

### Analytics instance

Creating an analytics instance with the player and the `.mux` option.

```swift
var analytics: AnalyticsAPI = PRESTOplaySDK.shared.analytics(for: player, .mux)
```

### Set custom metadata

Create and configure a `MUXSDKCustomerData` instance with the necessary details, then assign it to a `MuxMetata` instance.
For details on metadata, refer to the Mux Data guide:

- https://docs.mux.com/guides/monitor-avplayer
- https://docs.mux.com/guides/make-your-data-actionable-with-metadata

```swift
import CastlabsMux
import MuxCore

var analytics: AnalyticsAPI = PRESTOplaySDK.shared.analytics(for: player, .mux)

guard let playerData = MUXSDKCustomerPlayerData(environmentKey: "YOUR-ENV-KEY")
else { return nil }

let videoData = MUXSDKCustomerVideoData()
videoData.videoTitle = playerConfig.metaData?.title

let customerData = MUXSDKCustomerData()
customerData.customerPlayerData = playerData
customerData.customerVideoData = videoData

let metadata = MuxMetadata(
    live: playerConfiguration.live ?? false,
    assetId: "assetId")
metadata.customerData = customerData
return metadata
```
