The SDK provides a playlist-like behavior through the `PlaylistAPI` interface.
It is possible to implement multiple strategies or modes and expose it from a plugin.

## Implementations

Currently there are 2 playlist modes implemented.

### Native Queue

Exposed by `CastlabsApple` in `HLSPlugin` plugin.

It is an extensive and integrated wrapper over `AVQueuePlayer` implementation.
Native `AVQueuePlayer` is responsible for preloading and maintaining streaming items.

### Item Replace

Exposed by `CastlabsApple` in `HLSPlugin` plugin.

It uses single player. On item change the player replaces the current item played.
Effectively there is also only single, current item added to the player.

The plugin has partial control over how an item is loaded.

## Basic Usage

Ensure the `HLSPlugin` is enabled when registering the SDK, e.g.

```swift
import PRESTOplay
import CastlabsApple

let res = PRESTOplaySDK.shared.setup("LICENSE", [HLSPlugin()])
```

Create a player instance and load your playlist:

```swift
let player = PRESTOplaySDK.shared.player()
let playlist = PRESTOplaySDK.shared.playlist(for: player, mode: .nativeQueue)

let simplePlaylist = [
    PlayerConfiguration(with: URL(string: "stream1")!),
    PlayerConfiguration(with: URL(string: "stream2")!),
    PlayerConfiguration(with: URL(string: "stream3")!)
]
playlist?.load(items: simplePlaylist)
```

You can control player with regular `PlayerAPI` interface.

To play next or previous items:

```swift
playlist?.nextItem()
playlist?.previousItem()
```
