HLS playback is supported by our player engine with some key differences.

`PlayerEngine.apple`

- based on `AVPlayer` and other `AVFoundation` framework classes

* support for FairPlay Streaming and AirPlay

- no advanced tuning settings

## Picture in Picture

`Picture in Picture` is the ability to keep watching your video while interacting with other apps.

![](img/pip_hls.png)

Due to Apple restrictions, the feature is currently available only for HLS streams played with `PlayerEngine.apple`.

Although not exactly similar to the real Picture in Picture, you can enable one of these modes for the ViewController containing our Player View.

For more details on "Multitasking on iOS" : https://support.apple.com/en-us/HT202070

> You can use Picture in Picture with iPad Pro, iPad Air and later, and iPad mini 2 and later.

> Make sure to enable the `Audio, AirPlay, and Picture in Picture` background mode among your app capabilities.

## High Efficiency Video Coding (HEVC/H.265)

Our player supports HLS streams with HEVC encoded media.

HLS playback with `PlayerEngine.apple` is _limited_ to devices set with a processor newer or equal to A9 (iPhone 7 and above). Software decoding using `AVFoundation` is possible on all iOS/iPadOS devices. Our tests found that HEVC media is not playable on iPhone 6 devices.

For list of iOS/iPadOS devices supporting HEVC playback please view (this list may not be complete, _Capturing this media_):
https://support.apple.com/en-us/HT207022

For list of iOS/iPadOS devices supporting HEVC software decoding please visit (_Working with this media_):
https://support.apple.com/en-us/HT207022#working

Apple distinguishes decodable from playable content. Source:

https://devstreaming-cdn.apple.com/videos/wwdc/2017/503i6plfvfi7o3222/503/503_introducing_heif_and_hevc.pdf

https://developer.apple.com/videos/play/wwdc2017/503/
