//
//  ViewController.swift
//  ConvivaDemo
//
//

import PRESTOplay
import CastlabsApple
import CastlabsConviva
import AVFoundation
import UIKit

class ViewController: UIViewController {
    // create player instance
    var player = PRESTOplaySDK.shared.player()
    var analytics: AnalyticsAPI?

    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view.
        // optional: ignore silent switch
        try? AVAudioSession.sharedInstance().setCategory(.playback)

        guard let contentURL =
            URL(
                string: "https://demo.cf.castlabs.com/media/prestohls/master.m3u8")
        else { return }

        let config = PlayerConfiguration(with: contentURL)
        player.load(config: config)

        player.onState = { [weak self] previous, state in
            guard let self else { return }
            if let error = player.error {
                print("Error \(error)")
                return
            }
        }
        
        addConviva(config)

        player.attach(to: view.layer)
        player.open(autoplay: true)
    }

    override func viewWillTransition(to size: CGSize,
                                     with coordinator: UIViewControllerTransitionCoordinator) {
        player.update(size: size)
    }

    func addConviva(_ config: PlayerConfiguration) {
        guard var analytics = PRESTOplaySDK.shared.analytics(for: player, .conviva) else {
            return
        }

        let convivaMetadata = ConvivaMetadata(
            live: false,
            assetId: "conviva_assetId")
        convivaMetadata.assetName = config.metaData?.title
        analytics.metadata = convivaMetadata
        self.analytics = analytics
    }
}
