//
//  DemosView.swift
//  Demos
//
//

import PRESTOplay
import SwiftUI

struct Demo: Identifiable {
    let id = UUID()
    var title: String
    var description: String

    var url: String?
    var contentType: ContentType?
    var playerConfiguration: PlayerConfiguration?
    var drmConfiguration: DrmConfiguration?
    var sideloadedSubtitle: String?
    var sideloadedThumbnail: String?
    var displayInViewController: Bool?
    var youboraEnabled: Bool?
    var broadpeakEnabled: Bool?
    var convivaEnabled: Bool?
    var muxEnabled: Bool?
    var adsEnabled: Bool?
}

var drmConfiguration: DrmConfiguration {
    get {
        let drm = DrmConfiguration()
        drm.environment = .staging
        drm.merchant = "six"
        drm.assetId = "twelve"
        drm.userId = "rental1"
        drm.sessionId = "p0"
        return drm
    }
}

struct DemosView: View {
    @State var demos: [Demo]

    var body: some View {
        NavigationView {
            List(demos) { demo in
                NavigationLink {
                    if true == demo.displayInViewController ?? false {
                        PlayerViewController(demo: demo)
                    } else {
                        PlayerView(demo: demo)
                    }
                } label: {
                    VStack {
                        Text(demo.title)
                            .font(.headline)
                            .frame(maxWidth: .infinity, alignment: .leading)
                        Text(demo.description)
                            .font(.caption)
                            .frame(maxWidth: .infinity, alignment: .leading)
                            .multilineTextAlignment(.leading)
                    }
                }
                .padding(2.0)
            }
            .onAppear() {
                demos = getDemos()
            }
        }
    }

    func getDemos() -> [Demo] {
        let demos = [
            Demo(
                title: "HLS Playback",
                description: "Basic HLS playback demo",
                url: "https://demo.cf.castlabs.com/media/prestohls/master.m3u8"
            ),
            Demo(
                title: "Fairplay HLS Playback",
                description: "Basic Fairplay protected HLS playback demo",
                url: "https://demo.cf.castlabs.com/media/fps/prog_index.m3u8",
                drmConfiguration: drmConfiguration
            ),
            Demo(
                title: "DASH Playback",
                description: "Basic DASH playback demo",
                url: "https://demo.cf.castlabs.com/media/TOS/abr/Manifest_clean_sizes.mpd?v=10"
            ),
            Demo(
                title: "WebVTT Subtitles",
                description: "Add sideloaded WebVTT thumbnails",
                url: "https://demo.cf.castlabs.com/media/prestohls/master.m3u8",
                sideloadedSubtitle: "https://demo.cf.castlabs.com/media/players/presto.vtt"
            ),
            Demo(
                title: "WebVTT Thumbnails",
                description: "Add sideloaded WebVTT thumbnails",
                url: "https://demo.cf.castlabs.com/media/prestohls/master.m3u8",
                sideloadedThumbnail: "https://demo.castlabs.com/media/TOS/thumbs/thumbs.vtt"
            ),
            Demo(
                title: "Youbora Analytics",
                description: "Test integration with Youbora analytics",
                url: "https://demo.cf.castlabs.com/media/prestohls/master.m3u8",
                youboraEnabled: true
            ),
            Demo(
                title: "Broadpeak Analytics",
                description: "Test integration with Broadpeak analytics",
                url: "https://demo.cf.castlabs.com/media/prestohls/master.m3u8",
                broadpeakEnabled: true
            ),
            Demo(
                title: "Conviva Analytics",
                description: "Test integration with Conviva analytics",
                url: "https://demo.cf.castlabs.com/media/prestohls/master.m3u8",
                convivaEnabled: true
            ),
            Demo(
                title: "Mux Data Analytics",
                description: "Test integration with Mux Data analytics",
                url: "https://demo.cf.castlabs.com/media/prestohls/master.m3u8",
                muxEnabled: true
            ),
            Demo(
                title: "IMA Ads",
                description: "Test integration with Google IMA Ads",
                url: "https://demo.cf.castlabs.com/media/prestohls/master.m3u8",
                displayInViewController: true,
                adsEnabled: true
            )
        ]
        return demos
    }
}

struct DemosView_Previews: PreviewProvider {
    static var previews: some View {
        DemosView(demos: [])
    }
}
