//
//  CLPlaylistInternal.h
//  mpl
//
//  Created by Emil Pettersson on 06/04/16.
//  Copyright © 2016 castLabs GmbH. All rights reserved.
//

#import "CLPlaylist.h"

@interface CLPlaylist () {
    NSMutableArray<CLMovie*>* _movies;
}

@property (nullable, readwrite) NSString* url;

+ (nullable instancetype)playlistWithMovies:(nullable NSArray<CLMovie*>*)movies;
+ (nullable instancetype)playlistWithMovieCapacity:(NSUInteger)capacity;

- (nullable instancetype)initWithMovies:(nullable NSArray<CLMovie*>*)movies;
- (nullable instancetype)initWithMovieCapacity:(NSUInteger)capacity;

- (void)addMovie:(nonnull CLMovie*)movie;

@end
