MPEG-DASH playback is supported by our player engine with some key differences.

`PlayerEngine.castlabs`

- Based on `asl` - custom player engine, and other `AVFoundation` and `VideoToolbox` frameworks classes

* Support for Widevine
* Advanced tuning settings and customization

# MPEG-DASH

DASH playback is supported by our custom `VTPlayer` player which leverages the native `VideoToolbox` framework. On top of that we have implemented a native manifest parser, samples downloader and ABR algorithms.

`CastlabsVTWithWidevine` adds support for the `Widevine` CDM.

## ABR Settings

### Adaptive Bitrate Controls

NOTE: This document does not apply to the iOS/iPadOS native apple player aka AVPlayer. Only the castlabs player supports these functions.

When using the `Castlabs` player there are some additional APIs available to help control how the bitrate/quality is selected during playback.
The process for using them is as follows:

#### Steps to configure Abr Settings

1. If needed, enable DASH playback support by ensuring the `VTPlugin` is registered with the SDK, e.g.

   ```swift
   import PRESTOplay
   import CastlabsVT

   let res = PRESTOplaySDK.shared.setup("LICENSE", [VTPlugin()])
   ```

2. Before creating the player, ensure it will be the castlabs player and not the apple player. (NOTE: DASH content will always be played by the castlabs player regardless of this setting)

   ```swift
   let playerConfiguration = PlayerConfiguration(with: streamUrl)
   playerConfiguration.preferredEngine = .castlabs
   ```

3. Configure the bitrate adaptation settings (BEFORE playing the content)

   ```swift
   var abrConfiguration = AbrConfiguration()
   abrConfiguration.maxInitialBitrate = 1_000_000
   abrConfiguration.minDurationForQualityIncreaseMs = 6_000
   playerConfiguration.abrConfiguration = abrConfiguration

   let player = PRESTOplaySDK.shared.player(for: playerConfiguration)
   ```

   Please see AbrConfiguration.swift for details of all the parameters available.

## Buffer Settings

```swift
let player = PRESTOplaySDK.shared.player(for: playerConfiguration)

player.minPrebufferTime = 6.0
player.maxPrebufferTime = 60.0
player.minRebufferTime = 12.0
```

# Demo

Please find an example of ABR customization in `examples/CastlabsDASHDemo`.
