# Introduction

Examples use CocoaPods to download dependencies.

Please edit `Podfile` and for internal testing use:
```ruby
source 'git@github.com:castlabs/client_podspecs.git'
```

for publicly available release, please use:
```ruby
source 'git@github.com:castlabs/Specs.git'
```

# Build

1. Navigate into one of the demo projects e.g. `cd AppleHLSDemo`
2. Install dependencies `pod install --repo-update`
3. Open the generated `.xcworkspace` in Xcode, e.g. `open AppleHLSDemo.xcworkspace`
4. Locate and update Castlabs license information in the `AppDelegate.swift` file.

# CastlabsDASHDemo

Clear DASH playback is supported on iOS/iPadOS and tvOS.
MPEG-DASH protected with Widevine is supported only on iOS/iPadOS.

# CastlabsDASHWidevineDemo and Widevine support

Widevine protects its frameworks against fraudulent use. Debugging application that includes and decodes protected content is prohibited and ends with a crash.
To disable debugging please go to `Xcode` -> `Scheme` -> `Edit Scheme...` -> `Run` -> `Info` -> disable `Debug executable`.

# tvOS Demos
> **_NOTE:_** `Widevine`, `Chromecast`, `Downloader`, `MacCatalyst` demos are not supported on `tvOS`.
