//
//  CLMovie.h
//  mpl
//
//  Created by Emil Pettersson on 06/04/16.
//  Copyright © 2016 Castlabs GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "CLTrack.h"

@class CLPlaylist;

/**
 * CLMovie represents a movie with one or more tracks
 */
@interface CLMovie : NSObject

/**
 * Retrieve parent of movie
 */
@property (nullable, readonly, weak) CLPlaylist* parent;

/**
 * Retrieve duration of track (in seconds)
 */
@property (readonly) double duration;

/**
 * Movie name (if any)
 */
@property (nullable, readonly) NSString* name;

/**
 * An array with tracks for the movie
 */
@property (nonnull, readonly) NSArray<CLTrack*>* tracks;

/**
 * Access to tracks by type
 */
@property (nonnull, readonly) NSArray<CLTrack*>* videoTracks;
@property (nonnull, readonly) NSArray<CLTrack*>* audioTracks;
@property (nonnull, readonly) NSArray<CLTrack*>* textTracks;

@end
