//
//  CLMovieDownloadSetInternal.h
//  mpl
//
//  Created by Emil Pettersson on 08/04/16.
//  Copyright © 2016 Castlabs GmbH. All rights reserved.
//

#import "CLMovieDownloadSet.h"
#import "CLQualityDownloadInfo.h"

FOUNDATION_EXPORT NSString *const _Nonnull CLMoviePropertiesFileName;

@interface CLMovieDownloadSet () {
  NSMutableArray<CLQualityDownloadInfo *> *_selectedQualitiesInfo;
  NSMutableArray<CLQualityDownloadInfo *> *_downloadedQualitiesInfo;
  NSUInteger _numVideoQualities;
  NSUInteger _numAudioQualities;
  NSUInteger _numTextQualities;
  CLMutableMovieDownloadProperties *_properties;
  NSMapTable<CLQuality *, CLQualityDownloadInfo *> *_qualityInfoMap;

  NSUInteger _numSized;
  NSUInteger _numEstimated;
  NSUInteger _numActive;
  NSUInteger _numRunning;
  NSUInteger _numCompleted;
  NSUInteger _numFailed;
  CLDownloadSize _sizedBytes;
}

#pragma mark Internal Properties

// NOTE: we might want to move these if we implement a CLStreamDownloadSet
// wrapping multiple CLMovieDownloadSets
@property(nonnull, readonly) CLPlaylist *playlist;
@property(nonnull, readonly) NSString *downloadPath;
@property(nonnull, readonly) NSString *sourceURL;
@property(nonnull, readonly) NSString *baseURL;
@property(nonnull, readonly) NSString *downloadId;

@property(nonnull, readonly)
    NSArray<CLQualityDownloadInfo *> *selectedQualitiesInfo;
@property(nonnull, readonly)
    NSArray<CLQualityDownloadInfo *> *downloadedQualitiesInfo;

#pragma mark Internal APIs

- (BOOL)downloadWithAdditionalHeaders:
    (nullable NSDictionary<NSString *, NSString *> *)headers;
- (BOOL)reattachResource:(nonnull CLResourceId *)resourceId
                  toTask:(nonnull NSURLSessionDownloadTask *)task;

- (void)pause;
- (void)resume;
- (void)cancel;

- (void)resource:(nonnull CLResourceDownloadInfo *)resource
    completeWithError:(nullable NSError *)error;
- (void)resource:(nonnull CLResourceDownloadInfo *)resource
    bytesDownloaded:(int64_t)downloaded
        andExpected:(int64_t)expected;

#pragma mark Initialization & Creation

+ (nullable instancetype)
    downloadSetWithPlaylist:(nonnull CLPlaylist *)playlist
               downloadPath:(nonnull NSString *)downloadPath
               manifestName:(nonnull NSString *)manifestName
                  sourceURL:(nonnull NSString *)sourceURL
                 downloadId:(nonnull NSString *)downloadId
              andController:(nonnull id<CLSessionController>)controller;

- (nullable instancetype)initWithPlaylist:(nonnull CLPlaylist *)playlist
                             downloadPath:(nonnull NSString *)downloadPath
                             manifestName:(nonnull NSString *)manifestName
                                sourceURL:(nonnull NSString *)sourceURL
                               downloadId:(nonnull NSString *)downloadId
                            andController:
                                (nonnull id<CLSessionController>)controller;

@end
