//
//  CLResourceListBuilder.h
//  mpl
//
//  Created by Iskandar Safarov on 8/04/2016.
//  Copyright © 2016 Castlabs GmbH. All rights reserved.
//

#import "CLRangedURL.h"
#import <Foundation/Foundation.h>

/**
 * This is helper class which carries all required implementation-specific data
 * in order to do resource URL population
 */
@interface CLResourceListBuilder : NSObject

/**
 * Populate URLs
 * @param[in] baseURL The base URL for the resources
 */
- (nullable NSArray<CLRangedURL *> *)fillResourcesWithBaseURL:
    (nonnull NSString *)baseURL;

/**
 * Helper method for merging ranged URLs with the same underlying resource
 * @param[in] rangedURLs An array of URLs (assumed to be ordered by name & have
 * the same BaseURL)
 */
- (nullable NSArray<CLRangedURL *> *)mergeRangedResourceURLs:
    (nonnull NSArray<CLRangedURL *> *)rangedURLs;

@end
